#ifndef _ISO_88591_32_H_
#define _ISO_88591_32_H_
#include <devfont.h>

#define GAPS_BETWEEN_CHARACTER	3
#define TOTAL_CHARACTER_NUM 95

static const FONTINDEX ISO_88591_32_font_map[TOTAL_CHARACTER_NUM] = {
{0x0020,0x02,0x0000},
{0x0021,0x04,0x0008},
{0x0022,0x09,0x0018},
{0x0023,0x19,0x003C},
{0x0024,0x0C,0x00A0},
{0x0025,0x13,0x00D0},
{0x0026,0x0E,0x011C},
{0x0027,0x04,0x0154},
{0x0028,0x06,0x0164},
{0x0029,0x06,0x017C},
{0x002A,0x0C,0x0194},
{0x002B,0x10,0x01C4},
{0x002C,0x05,0x0204},
{0x002D,0x0E,0x0218},
{0x002E,0x04,0x0250},
{0x002F,0x0B,0x0260},
{0x0030,0x0C,0x028C},
{0x0031,0x0E,0x02BC},
{0x0032,0x0E,0x02F4},
{0x0033,0x0E,0x032C},
{0x0034,0x0E,0x0364},
{0x0035,0x0E,0x039C},
{0x0036,0x0E,0x03D4},
{0x0037,0x0E,0x040C},
{0x0038,0x0E,0x0444},
{0x0039,0x0E,0x047C},
{0x003A,0x04,0x04B4},
{0x003B,0x06,0x04C4},
{0x003C,0x0C,0x04DC},
{0x003D,0x0E,0x050C},
{0x003E,0x0C,0x0544},
{0x003F,0x0E,0x0574},
{0x0040,0x14,0x05AC},
{0x0041,0x0C,0x05FC},
{0x0042,0x0C,0x062C},
{0x0043,0x0C,0x065C},
{0x0044,0x0C,0x068C},
{0x0045,0x0B,0x06BC},
{0x0046,0x0B,0x06E8},
{0x0047,0x0C,0x0714},
{0x0048,0x0B,0x0744},
{0x0049,0x04,0x0770},
{0x004A,0x0C,0x0780},
{0x004B,0x0C,0x07B0},
{0x004C,0x0B,0x07E0},
{0x004D,0x11,0x080C},
{0x004E,0x0B,0x0850},
{0x004F,0x0C,0x087C},
{0x0050,0x0C,0x08AC},
{0x0051,0x0D,0x08DC},
{0x0052,0x0C,0x0910},
{0x0053,0x0C,0x0940},
{0x0054,0x0C,0x0970},
{0x0055,0x0C,0x09A0},
{0x0056,0x0C,0x09D0},
{0x0057,0x14,0x0A00},
{0x0058,0x0C,0x0A50},
{0x0059,0x0C,0x0A80},
{0x005A,0x0B,0x0AB0},
{0x005B,0x08,0x0ADC},
{0x005C,0x0B,0x0AFC},
{0x005D,0x08,0x0B28},
{0x005E,0x0F,0x0B48},
{0x005F,0x12,0x0B84},
{0x0060,0x08,0x0BCC},
{0x0061,0x0C,0x0BEC},
{0x0062,0x0C,0x0C1C},
{0x0063,0x0C,0x0C4C},
{0x0064,0x0C,0x0C7C},
{0x0065,0x0C,0x0CAC},
{0x0066,0x08,0x0CDC},
{0x0067,0x0C,0x0CFC},
{0x0068,0x0C,0x0D2C},
{0x0069,0x04,0x0D5C},
{0x006A,0x06,0x0D6C},
{0x006B,0x0B,0x0D84},
{0x006C,0x04,0x0DB0},
{0x006D,0x14,0x0DC0},
{0x006E,0x0C,0x0E10},
{0x006F,0x0C,0x0E40},
{0x0070,0x0C,0x0E70},
{0x0071,0x0C,0x0EA0},
{0x0072,0x0B,0x0ED0},
{0x0073,0x0C,0x0EFC},
{0x0074,0x08,0x0F2C},
{0x0075,0x0C,0x0F4C},
{0x0076,0x0C,0x0F7C},
{0x0077,0x14,0x0FAC},
{0x0078,0x0C,0x0FFC},
{0x0079,0x0C,0x102C},
{0x007A,0x0B,0x105C},
{0x007B,0x0A,0x1088},
{0x007C,0x04,0x10B0},
{0x007D,0x0A,0x10C0},
{0x007E,0x13,0x10E8},
};

static unsigned char ISO_88591_32_osdfont_dat[] = {
// 0x0020 2x32 --  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0021 4x32 --  !
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0x00,0x00,0x00,
// 0x0022 9x32 --  "
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x19,0xEF,0xF7,0xFB,0xFD,0xFE,0xFF,0x7F,0xBF,
0xDE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0023 25x32 --  #
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0x80,0x40,0x00,0xE0,0x78,0x00,0xF0,0x38,0x00,0x70,0x1C,0x00,
0x38,0x1C,0x07,0xFF,0xFF,0xF3,0xFF,0xFF,0xF9,0xFF,0xFF,0xFC,0x0E,0x03,0x80,0x07,
0x03,0x80,0x03,0x81,0xC0,0x03,0x81,0xE0,0x3F,0xFF,0xFF,0x1F,0xFF,0xFF,0x8F,0xFF,
0xFF,0xC0,0x70,0x38,0x00,0x78,0x1C,0x00,0x38,0x1C,0x00,0x1C,0x0E,0x00,0x1C,0x0F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0024 12x32 --  $
0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0xE0,0x1E,0x07,0xFC,0x7F,0xEF,0xFF,0xFE,
0xFF,0xEF,0xFE,0xFF,0xE0,0xFE,0x07,0xF8,0x3F,0xC0,0xFE,0x0E,0xF0,0xEF,0xFE,0xFF,
0xEF,0xFF,0xFF,0xFE,0x7F,0xC3,0xF8,0x0E,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0025 19x32 --  %
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,
0xC7,0xF0,0x30,0xE7,0x06,0x1C,0xE1,0x83,0x9C,0x70,0x73,0x8C,0x0E,0x73,0x01,0xCE,
0xE0,0x1F,0xD8,0x01,0xE6,0x00,0x00,0xC7,0x80,0x31,0xF8,0x0E,0x73,0x81,0x8E,0x70,
0x61,0xCE,0x1C,0x39,0xC3,0x07,0x38,0xC0,0xE7,0x18,0x0F,0xE6,0x00,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0026 14x32 --  &
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x7F,0xE1,
0xFF,0x8F,0x9F,0x3C,0x3C,0xF0,0xF3,0xC0,0x0F,0x80,0x1F,0xFF,0x7F,0xFD,0xE3,0xCF,
0x0F,0x3C,0x3C,0xF0,0xF3,0xC3,0xCF,0x8F,0x1F,0xF8,0x7F,0xE0,0x7E,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0027 4x32 --  '
0x00,0x00,0x00,0xCF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0028 6x32 --  (
0x00,0x00,0x00,0x00,0x01,0xCF,0x7F,0xEF,0x3C,0xF3,0xCF,0x3C,0xF3,0xCF,0x3C,0xF3,
0xCF,0x3C,0xF3,0xCF,0x3E,0x7C,0xF1,0xC0,
// 0x0029 6x32 --  )
0x00,0x00,0x00,0x00,0x0E,0x3C,0xF8,0xF3,0xCF,0x3C,0xF3,0xCF,0x3C,0xF3,0xCF,0x3C,
0xF3,0xCF,0x3C,0xF3,0xDF,0xFB,0xCE,0x00,
// 0x002A 12x32 --  *
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0xF6,0xFF,0xF7,0xFE,0x3F,
0xC1,0xF8,0x3F,0xCF,0xFF,0x7F,0xE0,0xF4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002B 16x32 --  +
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,
0x03,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002C 5x32 --  ,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x7B,
0xDC,0xEF,0x73,0x80,
// 0x002D 14x32 --  -
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC3,
0xFF,0x0F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002E 4x32 --  .
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,
// 0x002F 11x32 --  /
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x07,0x00,0xE0,0x38,0x07,0x01,
0xC0,0x38,0x07,0x01,0xC0,0x38,0x07,0x01,0xC0,0x38,0x0F,0x01,0xC0,0x38,0x0E,0x01,
0xC0,0x38,0x0E,0x01,0xC0,0x78,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0030 12x32 --  0
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF8,0x7F,0xE7,0xFE,0xF8,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0031 14x32 --  1
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x03,0xE0,
0x1F,0x80,0xFE,0x03,0x78,0x09,0xE0,0x07,0x80,0x1E,0x00,0x78,0x01,0xE0,0x07,0x80,
0x1E,0x00,0x78,0x01,0xE0,0x07,0x80,0x1E,0x00,0x78,0x01,0xE0,0x07,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0032 14x32 --  2
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x1F,0xF0,
0xFF,0xC7,0xCF,0x9E,0x1E,0x78,0x79,0xE1,0xC7,0x8F,0x00,0x78,0x03,0xC0,0x0E,0x00,
0x70,0x03,0xC0,0x1E,0x00,0xF0,0x03,0x80,0x1F,0xFC,0x7F,0xF1,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0033 14x32 --  3
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x3F,0xF0,
0xFF,0xC7,0xCF,0x9E,0x1E,0x78,0x78,0x01,0xE0,0x0F,0x00,0xF8,0x03,0xE0,0x07,0xC0,
0x07,0x80,0x1E,0x78,0x79,0xE1,0xE7,0xC7,0x8F,0xFC,0x3F,0xF0,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0034 14x32 --  4
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0xF0,
0x07,0x80,0x1C,0x00,0xF0,0x07,0x80,0x3C,0x00,0xE0,0x07,0x80,0x3C,0xF1,0xE3,0xC7,
0xFF,0xDF,0xFF,0x7F,0xFC,0x03,0xC0,0x0F,0x00,0x3C,0x00,0xF0,0x03,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0035 14x32 --  5
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFC,0x7F,0xF1,
0xFF,0xC7,0x80,0x1E,0x00,0x78,0x01,0xE0,0x07,0xFC,0x1F,0xFC,0x7F,0xF8,0x03,0xE0,
0x07,0x80,0x1E,0x78,0x79,0xE1,0xE7,0x8F,0x8F,0xFC,0x3F,0xF0,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0036 14x32 --  6
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x3F,0xF0,
0xFF,0xE7,0x87,0x9E,0x1E,0x78,0x01,0xE0,0x07,0xFC,0x1F,0xFC,0x7F,0xF9,0xE3,0xE7,
0x87,0x9E,0x1E,0x78,0x79,0xE1,0xE7,0xCF,0x8F,0xFC,0x3F,0xF0,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0037 14x32 --  7
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFE,0x3F,0xF8,
0xFF,0xE0,0x07,0x80,0x1C,0x00,0x70,0x03,0x80,0x0E,0x00,0x70,0x01,0xC0,0x0F,0x00,
0x38,0x00,0xE0,0x07,0x00,0x1C,0x00,0xF0,0x03,0x80,0x1E,0x00,0x70,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0038 14x32 --  8
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x3F,0xF0,
0xFF,0xC7,0xCF,0x9E,0x1E,0x78,0x79,0xE1,0xE3,0x8F,0x07,0xF8,0x3F,0xF1,0xFF,0xE7,
0xCF,0x9E,0x1E,0x78,0x79,0xE1,0xE7,0xC7,0x8F,0xFC,0x3F,0xF0,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0039 14x32 --  9
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x3F,0xF0,
0xFF,0xC7,0xCF,0x9E,0x1E,0x78,0x79,0xE1,0xE7,0x87,0x9F,0x3E,0x7F,0xF8,0xFF,0xE0,
0xFF,0x80,0x1E,0x00,0x79,0xE1,0xE7,0x87,0x9F,0xFC,0x3F,0xF0,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003A 4x32 --  :
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,
// 0x003B 6x32 --  ;
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0xF3,0xC0,0x00,0x00,0x00,0x00,
0x00,0x1F,0x79,0xE7,0x9C,0xF3,0x8E,0x00,
// 0x003C 12x32 --  <
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00,0xF0,0x7F,0x3F,0xEF,0xF0,0xF8,0x0F,0xC0,0xFF,0x01,
0xFE,0x07,0xF0,0x0F,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003D 14x32 --  =
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003E 12x32 --  >
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x00,0xF0,0x0F,0xE0,0x7F,0x81,0xFE,0x03,0xE0,0x3F,0x1F,0xF7,
0xF8,0xFC,0x0F,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003F 14x32 --  ?
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0F,0xFC,0x3F,0xF1,
0xE1,0xE7,0x87,0x9E,0x1E,0x00,0x78,0x01,0xE0,0x07,0x80,0x1E,0x00,0xF8,0x0F,0xC0,
0x3F,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x07,0x80,0x1E,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0040 20x32 --  @
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x0F,0xFF,0x01,0xE0,0x78,0x38,0x01,
0xC7,0x07,0x8E,0x61,0xFC,0x6C,0x19,0xC3,0xC0,0xFC,0x3C,0x1F,0xC3,0xC3,0x9C,0x3C,
0x39,0xC3,0x63,0xFC,0x66,0x0F,0xCE,0x30,0x0F,0xC1,0xC0,0xF8,0x0F,0x80,0x00,0x1C,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0041 12x32 --  A
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0xF0,0x0F,0x01,0xF8,0x1F,
0x81,0xF8,0x1F,0x81,0xF8,0x3F,0xC3,0xFC,0x3F,0xC3,0xDC,0x39,0xC7,0xFE,0x7F,0xE7,
0xFE,0x70,0xE7,0x0E,0xE0,0x7E,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0042 12x32 --  B
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x8F,0xFE,0xFF,0xEF,0x0F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF1,0xFF,0xFE,0xFF,0xCF,0xFE,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF0,0xFF,0xFF,0xFF,0xEF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0043 12x32 --  C
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x87,0xFE,0x7F,0xEF,0x9F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0044 12x32 --  D
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x8F,0xFE,0xFF,0xEF,0x0F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF0,0xFF,0xFF,0xFF,0xEF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0045 11x32 --  E
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFE,0x03,0xC0,0x78,
0x0F,0x01,0xE0,0x3C,0x07,0xFF,0xFF,0xFF,0xFF,0xC0,0x78,0x0F,0x01,0xE0,0x3C,0x07,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0046 11x32 --  F
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFE,0x03,0xC0,0x78,
0x0F,0x01,0xE0,0x3C,0x07,0xFF,0xFF,0xFF,0xFF,0xC0,0x78,0x0F,0x01,0xE0,0x3C,0x07,
0x80,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0047 12x32 --  G
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x87,0xFE,0x7F,0xEF,0x9F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF3,0xFF,0x3F,0xF3,0xFF,
0x0F,0xF8,0xF7,0xFF,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0048 11x32 --  H
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x7F,0x8F,0xF1,0xFE,0x3F,0xC7,0xF8,
0xFF,0x1F,0xE3,0xFC,0x7F,0xFF,0xFF,0xFF,0xFF,0xC7,0xF8,0xFF,0x1F,0xE3,0xFC,0x7F,
0x8F,0xF1,0xFE,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0049 4x32 --  I
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x004A 12x32 --  J
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,
0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004B 12x32 --  K
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x1E,0xF1,0xCF,0x3C,0xF7,
0x8F,0xF0,0xFE,0x0F,0xE0,0xFC,0x0F,0x80,0xF8,0x0F,0xC0,0xFC,0x0F,0xE0,0xFF,0x0F,
0x78,0xF3,0x8F,0x3C,0xF1,0xEF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004C 11x32 --  L
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x07,0x80,0xF0,0x1E,0x03,0xC0,0x78,
0x0F,0x01,0xE0,0x3C,0x07,0x80,0xF0,0x1E,0x03,0xC0,0x78,0x0F,0x01,0xE0,0x3C,0x07,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004D 17x32 --  M
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x3F,0xF0,
0x1F,0xF8,0x0F,0xFC,0x07,0xFF,0x07,0xFF,0x83,0xFF,0xC1,0xFF,0xF0,0xFF,0xF8,0xFF,
0xFC,0x7F,0xFF,0x3F,0xFF,0x9F,0xFD,0xDD,0xFE,0xFE,0xFF,0x7F,0x7F,0x9F,0xBF,0xCF,
0x9F,0xE7,0xCF,0xF3,0xE7,0xF8,0xF3,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x004E 11x32 --  N
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x7F,0xCF,0xF9,0xFF,0x3F,0xF7,0xFE,
0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xDF,0xFB,0xFF,0x3F,0xE7,0xFC,0xFF,
0x8F,0xF1,0xFE,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004F 12x32 --  O
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x87,0xFE,0x7F,0xEF,0x8F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0050 12x32 --  P
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x8F,0xFE,0xFF,0xEF,0x0F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0xFF,0xFF,0xEF,0xFC,0xF0,0x0F,
0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0051 13x32 --  Q
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x0F,0xFC,0x7F,0xE7,0xCF,
0xBC,0x3D,0xE1,0xEF,0x0F,0x78,0x7B,0xC3,0xDE,0x1E,0xF0,0xF7,0x87,0xBC,0x3D,0xE1,
0xEF,0x3F,0x7B,0xFB,0xEF,0xCF,0xFE,0x7F,0xF8,0xFD,0xC0,0x04,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0052 12x32 --  R
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x8F,0xFE,0xFF,0xEF,0x1F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x1F,0xFF,0xEF,0xFC,0xFF,0xEF,0x1F,0xF0,0xFF,
0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0053 12x32 --  S
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x87,0xFE,0xFF,0xEF,0x1F,0xF0,
0xFF,0x0F,0xF0,0x0F,0x00,0xF0,0x07,0xF8,0x1F,0xC0,0x1E,0x00,0xF0,0x0F,0xF0,0xFF,
0x0F,0xF8,0xF7,0xFF,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0054 12x32 --  T
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF0,0xF0,0x0F,
0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,
0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0055 12x32 --  U
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,
0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0056 12x32 --  V
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0x70,0xE7,0x0E,0x71,
0xE7,0x9E,0x79,0xE3,0x9C,0x39,0xC3,0x9C,0x3B,0xC3,0xFC,0x1F,0x81,0xF8,0x1F,0x81,
0xF8,0x1F,0x80,0xF0,0x0F,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0057 20x32 --  W
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,
0xF0,0xFF,0x0F,0x0F,0x70,0xF0,0xF7,0x0F,0x8F,0x71,0xF8,0xE7,0x9F,0x8E,0x79,0xF9,
0xE3,0x9F,0x9E,0x39,0xF9,0xE3,0x9F,0xDC,0x3B,0xFD,0xC3,0xFD,0xDC,0x1F,0x9F,0xC1,
0xF9,0xFC,0x1F,0x9F,0x81,0xF9,0xF8,0x1F,0x8F,0x80,0xF0,0xF8,0x0F,0x0F,0x00,0xF0,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0058 12x32 --  X
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xF7,0x0E,0x70,0xE7,0x9C,0x39,
0xC3,0xBC,0x1F,0x81,0xF8,0x1F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x01,0xF8,0x1F,0x83,
0xF8,0x39,0xC3,0x9C,0x79,0xE7,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0059 12x32 --  Y
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0x0F,0x70,0xE7,0x9E,0x79,
0xE3,0x9C,0x39,0xC3,0xFC,0x3F,0x81,0xF8,0x1F,0x81,0xF8,0x0F,0x00,0xF0,0x0F,0x00,
0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005A 11x32 --  Z
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xE0,0x3C,0x07,0x01,
0xE0,0x38,0x0F,0x01,0xC0,0x78,0x0E,0x03,0xC0,0x70,0x1E,0x03,0x80,0xF0,0x1C,0x07,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005B 8x32 --  [
0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xFF,0xFF,0xFF,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xFF,0xFF,0xFF,0xF0,0x00,
// 0x005C 11x32 --  "\"
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x07,0x80,0x70,0x0E,0x01,0xE0,0x1C,
0x03,0x80,0x38,0x07,0x00,0xF0,0x0E,0x01,0xC0,0x3C,0x03,0x80,0x70,0x07,0x00,0xE0,
0x1E,0x01,0xC0,0x38,0x07,0x80,0x70,0x00,0x00,0x00,0x00,0x00,
// 0x005D 8x32 --  ]
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0x00,
// 0x005E 15x32 --  ^
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF0,0x03,0xE0,0x0F,
0xE0,0x1D,0xC0,0x73,0xC0,0xE3,0x83,0x87,0x8F,0x07,0x9C,0x07,0x78,0x0F,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005F 18x32 --  _
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0060 8x32 --  `
0x00,0xF0,0x78,0x1C,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0061 12x32 --  a
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x83,0xFE,0x7F,0xEF,0x1F,0xF0,0xF0,0x0F,0x1F,0xF7,0xFF,0x79,0xFF,
0x0F,0xF8,0xFF,0xFF,0x7F,0xF1,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0062 12x32 --  b
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,
0x0F,0x00,0xFF,0x8F,0xFE,0xFF,0xFF,0x1F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xFF,0xFF,0xFF,0xEF,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0063 12x32 --  c
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x87,0xFE,0x7F,0xEF,0x9F,0xF0,0xFF,0x0F,0xF0,0x0F,0x00,0xF0,0xFF,
0x0F,0xF8,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0064 12x32 --  d
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,
0xF0,0x0F,0x1F,0xF7,0xFF,0xFF,0xFF,0x8F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xFF,0xFF,0x7F,0xF1,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0065 12x32 --  e
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x87,0xFE,0x7F,0xFF,0x0F,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x0F,
0x0F,0xF8,0xF7,0xFE,0x7F,0xC1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0066 8x32 --  f
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0F,0x1F,0x3E,0x3C,0x3C,0xFF,0xFF,0xFF,0x3C,
0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0067 12x32 --  g
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1E,0xF7,0xFF,0xFF,0xFF,0x9F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xFF,0xFF,0x7F,0xF1,0xFF,0x00,0xFF,0x0F,0xF1,0xF7,0xFE,0x3F,0xC1,0xF0,
// 0x0068 12x32 --  h
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,
0x0F,0x00,0xFF,0x8F,0xFE,0xFF,0xFF,0x1F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0069 4x32 --  i
0x00,0x00,0x00,0xCF,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x006A 6x32 --  j
0x00,0x00,0x00,0x00,0x03,0x0F,0x3C,0xF0,0x00,0x3C,0xF3,0xCF,0x3C,0xF3,0xCF,0x3C,
0xF3,0xCF,0x3C,0xF3,0xCF,0x7F,0xEF,0x38,
// 0x006B 11x32 --  k
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x07,0x80,0xF0,0x1E,0x03,0xC0,0x78,
0x0F,0x1F,0xE7,0xBD,0xE7,0xF8,0xFE,0x1F,0x83,0xE0,0x7E,0x0F,0xE1,0xFE,0x3D,0xE7,
0xBE,0xF3,0xDE,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x006C 4x32 --  l
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x006D 20x32 --  m
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x8F,
0x8F,0xFF,0xFE,0xFF,0xFF,0xEF,0x1F,0x9F,0xF0,0xF0,0xFF,0x0F,0x0F,0xF0,0xF0,0xFF,
0x0F,0x0F,0xF0,0xF0,0xFF,0x0F,0x0F,0xF0,0xF0,0xFF,0x0F,0x0F,0xF0,0xF0,0xFF,0x0F,
0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x006E 12x32 --  n
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0x8F,0xFE,0xFF,0xFF,0x1F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x006F 12x32 --  o
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x87,0xFE,0x7F,0xEF,0x9F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xF7,0xFE,0x7F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0070 12x32 --  p
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0x8F,0xFE,0xFF,0xFF,0x9F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF1,0xFF,0xFF,0xFF,0xEF,0xF8,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0C,0x00,
// 0x0071 12x32 --  q
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1E,0xF7,0xFF,0xFF,0xFF,0x9F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF9,0xFF,0xFF,0x7F,0xF1,0xFF,0x00,0xF0,0x0F,0x00,0xF0,0x0F,0x00,0xF0,0x0F,
// 0x0072 11x32 --  r
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xF9,0xFF,0xFF,0xE7,0x80,0xF0,0x1E,0x03,0xC0,0x78,0x0F,0x01,0xE0,0x3C,0x07,
0x80,0xF0,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0073 12x32 --  s
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x87,0xFC,0x7F,0xEF,0x0F,0xF0,0x0F,0xF8,0xFF,0xE7,0xFF,0x1F,0xF0,
0x0F,0xF0,0xF7,0xFE,0x3F,0xE1,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0074 8x32 --  t
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x3C,0x3C,0xFF,0xFF,0xFF,0x3C,
0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3F,0x3F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0075 12x32 --  u
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,0x0F,0xF0,0xFF,
0x0F,0xF8,0xFF,0xFF,0x7F,0xF1,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0076 12x32 --  v
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xF0,0xFF,0x0F,0x70,0xE7,0x9E,0x79,0xE3,0x9C,0x39,0xC3,0xBC,0x3F,0x81,
0xF8,0x1F,0x81,0xF8,0x0F,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0077 20x32 --  w
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,
0xFF,0x0F,0x0F,0x70,0xF8,0xF7,0x9F,0x8E,0x79,0xF9,0xE3,0x9F,0x9E,0x39,0xFD,0xC3,
0xFD,0xDC,0x3F,0x9F,0xC1,0xF9,0xF8,0x1F,0x9F,0x81,0xF8,0xF8,0x0F,0x0F,0x80,0xF0,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0078 12x32 --  x
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xF0,0xF7,0x8E,0x79,0xE3,0x9C,0x3F,0xC1,0xF8,0x1F,0x80,0xF8,0x1F,0x83,
0xFC,0x39,0xC7,0x9E,0x70,0xEF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0079 12x32 --  y
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xF0,0xFF,0x0F,0x70,0xE7,0x9E,0x79,0xE3,0x9C,0x3D,0xC3,0xDC,0x1F,0xC1,
0xF8,0x1F,0x80,0xF8,0x0F,0x00,0xF0,0x07,0x00,0xF0,0x0E,0x00,0xE0,0x0E,0x01,0xC0,
// 0x007A 11x32 --  z
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xF8,0x1E,0x03,0x80,0xF0,0x3C,0x0F,0x01,0xC0,0x78,0x1E,0x07,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x007B 10x32 --  {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x0F,0x07,0xC3,0xC0,0xF0,0x3C,0x0F,
0x03,0xC0,0xE0,0xF0,0x70,0x38,0x07,0x00,0xE0,0x1C,0x03,0xC0,0xF0,0x3C,0x0F,0x03,
0xC0,0xF0,0x3E,0x07,0xC0,0xF0,0x1C,0x00,
// 0x007C 4x32 --  |
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
// 0x007D 10x32 --  }
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x03,0xC0,0x78,0x0F,0x03,0xC0,0xF0,0x3C,
0x0F,0x01,0xC0,0x1C,0x03,0x80,0x70,0x38,0x1C,0x0E,0x0F,0x03,0xC0,0xF0,0x3C,0x0F,
0x03,0xC1,0xF0,0xF8,0x3C,0x0E,0x00,0x00,
// 0x007E 19x32 --  ~
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x78,0x07,0x1F,0xC1,0xC7,0x1C,0x39,0xC1,0xCE,0x38,0x1F,0x8E,
0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

static unsigned char * ISO_88591_32GetCharacterFontBit(unsigned short ch, unsigned short *font_width)
{
    int iIndex, iUpPos = 0, iDownPos = TOTAL_CHARACTER_NUM;
//    unsigned char *font_dat = NULL;
    
    while(iUpPos <= iDownPos){
        iIndex = (iUpPos + iDownPos) >> 1 ;
        if(ISO_88591_32_font_map[iIndex].character == ch) //found this character
            break ;
        else if(ISO_88591_32_font_map[iIndex].character > ch)
            iDownPos = iIndex - 1;
        else
            iUpPos = iIndex + 1;
    }
    if(iUpPos > iDownPos)//don't found character font data
        iIndex = 0 ;//use first character font data
    *font_width = ISO_88591_32_font_map[iIndex].width ;

    return (unsigned char *)&ISO_88591_32_osdfont_dat[ISO_88591_32_font_map[iIndex].offset] ;
}

FONT ISO_88591_32Font = {
    "ISO_88591_32",
    32,
    0,
    32,
    0,
    GAPS_BETWEEN_CHARACTER,
    TOTAL_CHARACTER_NUM,
    ISO_88591_32GetCharacterFontBit
} ;

#undef GAPS_BETWEEN_CHARACTER
#undef TOTAL_CHARACTER_NUM
#endif