/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.outline.IProblem;
import org.eclipse.ant.internal.ui.editor.text.IXMLAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class XMLProblemAnnotation
extends Annotation
implements IXMLAnnotation {
    private List fOverlaids;
    private IProblem fProblem;

    public XMLProblemAnnotation(IProblem problem) {
        this.fProblem = problem;
        if (this.fProblem.isError()) {
            this.setType("org.eclipse.ui.workbench.texteditor.error");
        } else if (this.fProblem.isWarning()) {
            this.setType("org.eclipse.ui.workbench.texteditor.warning");
        } else {
            this.setType("org.eclipse.ui.workbench.texteditor.info");
        }
    }

    public Image getImage(Display display) {
        return null;
    }

    public String getMessage() {
        return this.fProblem.getMessage();
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean isProblem() {
        return "org.eclipse.ui.workbench.texteditor.warning".equals(this.getType()) || "org.eclipse.ui.workbench.texteditor.error".equals(this.getType());
    }

    public boolean isRelevant() {
        return true;
    }

    public boolean hasOverlay() {
        return false;
    }

    public void addOverlaid(IXMLAnnotation annotation) {
        if (this.fOverlaids == null) {
            this.fOverlaids = new ArrayList(1);
        }
        this.fOverlaids.add(annotation);
    }

    public void removeOverlaid(IXMLAnnotation annotation) {
        if (this.fOverlaids != null) {
            this.fOverlaids.remove(annotation);
            if (this.fOverlaids.size() == 0) {
                this.fOverlaids = null;
            }
        }
    }

    public Iterator getOverlaidIterator() {
        if (this.fOverlaids != null) {
            return this.fOverlaids.iterator();
        }
        return null;
    }
}

