/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class LastSaveReferenceProvider
implements IQuickDiffReferenceProvider,
IElementStateListener {
    private boolean fDocumentRead = false;
    private IDocument fReference = null;
    private String fId;
    private IDocumentProvider fDocumentProvider;
    private IEditorInput fEditorInput;
    private final Object fLock = new Object();
    private IProgressMonitor fProgressMonitor;
    private ITextEditor fEditor;

    public IDocument getReference(IProgressMonitor monitor) {
        if (!this.fDocumentRead) {
            this.readDocument(monitor, true);
        }
        return this.fReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IProgressMonitor monitor = this.fProgressMonitor;
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        IDocumentProvider provider = this.fDocumentProvider;
        Object object = this.fLock;
        synchronized (object) {
            if (provider != null) {
                provider.removeElementStateListener((IElementStateListener)this);
            }
            this.fEditorInput = null;
            this.fDocumentProvider = null;
            this.fReference = null;
            this.fDocumentRead = false;
            this.fProgressMonitor = null;
            this.fEditor = null;
        }
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveEditor(ITextEditor targetEditor) {
        IDocumentProvider provider = null;
        IEditorInput input = null;
        if (targetEditor != null) {
            provider = targetEditor.getDocumentProvider();
            input = targetEditor.getEditorInput();
        }
        if (provider != this.fDocumentProvider || input != this.fEditorInput) {
            this.dispose();
            Object object = this.fLock;
            synchronized (object) {
                this.fEditor = targetEditor;
                this.fDocumentProvider = provider;
                this.fEditorInput = input;
            }
        }
    }

    public boolean isEnabled() {
        return this.fEditorInput != null && this.fDocumentProvider != null;
    }

    public void setId(String id) {
        this.fId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDocument(IProgressMonitor monitor, boolean force) {
        IDocumentProvider prov = this.fDocumentProvider;
        IEditorInput inp = this.fEditorInput;
        IDocument doc = this.fReference;
        ITextEditor editor = this.fEditor;
        if (prov instanceof IStorageDocumentProvider && inp instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)inp;
            IStorageDocumentProvider provider = (IStorageDocumentProvider)prov;
            if (doc == null) {
                if (force || this.fDocumentRead) {
                    doc = new Document();
                } else {
                    return;
                }
            }
            IJobManager jobMgr = Platform.getJobManager();
            IFile file = input.getFile();
            try {
                this.fProgressMonitor = monitor;
                jobMgr.beginRule((ISchedulingRule)file, monitor);
                InputStream stream = LastSaveReferenceProvider.getFileContents(file);
                if (stream == null) {
                    return;
                }
                String encoding = file.getCharset();
                if (encoding == null) {
                    return;
                }
                boolean skipUTF8BOM = LastSaveReferenceProvider.isUTF8BOM(encoding, file);
                LastSaveReferenceProvider.setDocumentContent(doc, stream, encoding, monitor, skipUTF8BOM);
            }
            catch (IOException e) {
                return;
            }
            catch (CoreException e) {
                return;
            }
            finally {
                jobMgr.endRule((ISchedulingRule)file);
                this.fProgressMonitor = null;
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            Object object = this.fLock;
            synchronized (object) {
                if (this.fDocumentProvider == provider && this.fEditorInput == input) {
                    this.fReference = doc;
                    this.fDocumentRead = true;
                    this.addElementStateListener(editor, prov);
                }
            }
        }
    }

    private void addElementStateListener(ITextEditor editor, IDocumentProvider provider) {
        provider.addElementStateListener((IElementStateListener)this);
    }

    private static InputStream getFileContents(IFile file) {
        InputStream stream = null;
        try {
            if (file != null) {
                stream = file.getContents();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding, IProgressMonitor monitor, boolean skipUTF8BOM) throws IOException {
        block11: {
            block10: {
                in = null;
                try {
                    if (skipUTF8BOM) {
                        for (i = 0; i < 3; ++i) {
                            if (contentStream.read() != -1) continue;
                            throw new IOException(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.notEnoughBytesForBOM"));
                        }
                    }
                    DEFAULT_FILE_SIZE = 15360;
                    in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                    buffer = new StringBuffer(15360);
                    readBuffer = new char[2048];
                    n = in.read(readBuffer);
                    while (n > 0) {
                        if (monitor != null && monitor.isCanceled()) {
                            var11_10 = null;
                            if (in == null) return;
                            break block10;
                        }
                        buffer.append(readBuffer, 0, n);
                        n = in.read(readBuffer);
                    }
                    document.set(buffer.toString());
                    break block11;
                }
                catch (Throwable var10_16) {
                    var11_12 = null;
                    if (in == null) throw var10_16;
                    try {
                        in.close();
                        throw var10_16;
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    throw var10_16;
                }
            }
            ** try [egrp 1[TRYBLOCK] [3 : 175->183)] { 
lbl37:
            // 1 sources

            in.close();
            return;
lbl39:
            // 1 sources

            catch (IOException x) {
                // empty catch block
            }
            return;
        }
        var11_11 = null;
        if (in == null) return;
        try {}
        catch (IOException x) {
            return;
        }
        in.close();
    }

    private static boolean isUTF8BOM(String encoding, IFile file) throws CoreException {
        byte[] bom;
        IContentDescription description;
        if ("UTF-8".equals(encoding) && (description = file.getContentDescription()) != null && (bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
            if (bom != IContentDescription.BOM_UTF_8) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.wrongByteOrderMark"), null));
            }
            return true;
        }
        return false;
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
        if (!isDirty && element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        if (element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementDeleted(Object element) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    private final class ReadJob
    extends Job {
        public ReadJob() {
            super(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.readJob.label"));
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LastSaveReferenceProvider.this.readDocument(monitor, false);
            return Status.OK_STATUS;
        }
    }
}

