/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ManagedForm
implements IManagedForm {
    private Object input;
    private ScrolledForm form;
    private FormToolkit toolkit;
    private Object container;
    private boolean ownsToolkit;
    private Vector parts = new Vector();

    public ManagedForm(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.ownsToolkit = true;
        this.form = this.toolkit.createScrolledForm(parent);
    }

    public ManagedForm(FormToolkit toolkit, ScrolledForm form) {
        this.form = form;
        this.toolkit = toolkit;
    }

    public void addPart(IFormPart part) {
        this.parts.add(part);
    }

    public void removePart(IFormPart part) {
        this.parts.remove(part);
    }

    public IFormPart[] getParts() {
        return this.parts.toArray(new IFormPart[this.parts.size()]);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public void reflow(boolean changed) {
        this.form.reflow(changed);
    }

    public void fireSelectionChanged(IFormPart part, ISelection selection) {
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart cpart = (IFormPart)this.parts.get(i);
            if (part.equals(cpart) || !(cpart instanceof IPartSelectionListener)) continue;
            ((IPartSelectionListener)((Object)cpart)).selectionChanged(part, selection);
        }
    }

    public void initialize() {
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.initialize(this);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.dispose();
        }
        if (this.ownsToolkit) {
            this.toolkit.dispose();
        }
    }

    public void refresh() {
        int nrefreshed = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            if (!part.isStale()) continue;
            part.refresh();
            ++nrefreshed;
        }
        if (nrefreshed > 0) {
            this.form.reflow(true);
        }
    }

    public void commit(boolean onSave) {
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            if (!part.isDirty()) continue;
            part.commit(onSave);
        }
    }

    public boolean setInput(Object input) {
        boolean pageResult = false;
        this.input = input;
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            boolean result = part.setFormInput(input);
            if (!result) continue;
            pageResult = true;
        }
        return pageResult;
    }

    public Object getInput() {
        return this.input;
    }

    public void setFocus() {
        if (this.parts.size() > 0) {
            IFormPart part = (IFormPart)this.parts.get(0);
            part.setFocus();
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            if (!part.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isStale() {
        for (int i = 0; i < this.parts.size(); ++i) {
            IFormPart part = (IFormPart)this.parts.get(i);
            if (!part.isStale()) continue;
            return true;
        }
        return false;
    }

    public void dirtyStateChanged() {
    }

    public void staleStateChanged() {
    }

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }
}

