/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.site.SiteBuildFeature;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuiltFeaturesWizardPage
extends WizardPage {
    private ISiteBuildModel model;
    private TablePart checkboxTablePart;
    private CheckboxTableViewer featureViewer;

    public BuiltFeaturesWizardPage(ISiteBuildModel model) {
        super("BuiltFeaturesWizardPage");
        this.model = model;
        this.setTitle(PDEPlugin.getResourceString("BuildFeatureWizardPage.title"));
        this.setDescription(PDEPlugin.getResourceString("BuildFeatureWizardPage.desc"));
        this.setPageComplete(false);
        this.checkboxTablePart = new TablePart();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createPluginList(container);
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_included_features_wizard");
    }

    protected void createPluginList(Composite parent) {
        this.checkboxTablePart.createControl(parent);
        this.featureViewer = this.checkboxTablePart.getTableViewer();
        this.featureViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.featureViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.featureViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IFeatureModel) {
                    IFeatureModel model = (IFeatureModel)object;
                    return !BuiltFeaturesWizardPage.this.isOnTheList(model);
                }
                return true;
            }
        });
        GridData gd = (GridData)this.checkboxTablePart.getControl().getLayoutData();
        gd.heightHint = 300;
    }

    private boolean isOnTheList(IFeatureModel candidate) {
        ISiteBuildFeature[] features = this.model.getSiteBuild().getFeatures();
        IFeature cfeature = candidate.getFeature();
        for (int i = 0; i < features.length; ++i) {
            ISiteBuildFeature bfeature = features[i];
            if (!bfeature.getId().equals(cfeature.getId()) || !bfeature.getVersion().equals(cfeature.getVersion())) continue;
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.featureViewer.setInput((Object)this.model.getSiteBuild());
        this.checkboxTablePart.setSelection(new Object[0]);
    }

    private Object[] getChoices() {
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        return mng.getFeatureModels();
    }

    public boolean finish() {
        final Object[] candidates = this.checkboxTablePart.getSelection();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    BuiltFeaturesWizardPage.this.doAdd(candidates, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private void doAdd(Object[] candidates, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString("BuildFeatureWizardPage.adding"), candidates.length + 1);
        ISiteBuild siteBuild = this.model.getSiteBuild();
        ISiteBuildFeature[] added = new ISiteBuildFeature[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            String name = candidate.getFeature().getLabel();
            monitor.subTask(candidate.getResourceString(name));
            SiteBuildFeature child = (SiteBuildFeature)this.model.createFeature();
            child.setReferencedFeature(candidate.getFeature());
            added[i] = child;
            monitor.worked(1);
        }
        monitor.subTask("");
        monitor.setTaskName(PDEPlugin.getResourceString("BuildFeatureWizardPage.updating"));
        siteBuild.addFeatures(added);
        monitor.worked(1);
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart() {
            super(PDEPlugin.getResourceString("BuildFeatureWizardPage.label"));
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            BuiltFeaturesWizardPage.this.setPageComplete(count > 0);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.FEATURE_SORTER);
            return viewer;
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return BuiltFeaturesWizardPage.this.getChoices();
        }
    }
}

