/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

public abstract class TextUtil {
    public static String createMultiLine(String text, int limit) {
        return TextUtil.createMultiLine(text, limit, false);
    }

    public static String createMultiLine(String text, int limit, boolean ignoreNewLine) {
        StringBuffer buffer = new StringBuffer();
        int counter = 0;
        boolean preformatted = false;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.charAt(i);
            ++counter;
            if (c == 60) {
                if (TextUtil.isPreStart(text, i)) {
                    preformatted = true;
                } else if (TextUtil.isPreEnd(text, i)) {
                    preformatted = false;
                } else if (TextUtil.isParagraph(text, i)) {
                    buffer.append("\n<p>\n");
                    counter = 0;
                    i += 2;
                    continue;
                }
            }
            if (preformatted) {
                if (c == 10) {
                    counter = 0;
                }
                buffer.append((char)c);
                continue;
            }
            if (Character.isWhitespace((char)c)) {
                if (counter == 1) {
                    counter = 0;
                    continue;
                }
                if (counter > limit) {
                    buffer.append('\n');
                    counter = 0;
                    --i;
                    continue;
                }
            }
            if (c == 10) {
                if (ignoreNewLine) {
                    c = 32;
                } else {
                    counter = 0;
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private static boolean isParagraph(String text, int loc) {
        if (text.charAt(loc) != '<') {
            return false;
        }
        if (loc + 2 >= text.length()) {
            return false;
        }
        if (text.charAt(loc + 1) != 'p') {
            return false;
        }
        return text.charAt(loc + 2) == '>';
    }

    private static boolean isPreEnd(String text, int loc) {
        if (text.charAt(loc) != '<') {
            return false;
        }
        if (loc + 5 >= text.length()) {
            return false;
        }
        if (text.charAt(loc + 1) != '/') {
            return false;
        }
        if (text.charAt(loc + 2) != 'p') {
            return false;
        }
        if (text.charAt(loc + 3) != 'r') {
            return false;
        }
        if (text.charAt(loc + 4) != 'e') {
            return false;
        }
        return text.charAt(loc + 5) == '>';
    }

    private static boolean isPreStart(String text, int loc) {
        if (text.charAt(loc) != '<') {
            return false;
        }
        if (loc + 4 >= text.length()) {
            return false;
        }
        if (text.charAt(loc + 1) != 'p') {
            return false;
        }
        if (text.charAt(loc + 2) != 'r') {
            return false;
        }
        if (text.charAt(loc + 3) != 'e') {
            return false;
        }
        return text.charAt(loc + 4) == '>';
    }
}

