/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BreakpointsSorter
extends ViewerSorter {
    public boolean isSorterProperty(Object element, String propertyId) {
        return propertyId.equals("org.eclipse.jface.text");
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String modelId2;
        IBreakpoint b1 = (IBreakpoint)e1;
        IBreakpoint b2 = (IBreakpoint)e2;
        String modelId1 = b1.getModelIdentifier();
        int result = modelId1.compareTo(modelId2 = b2.getModelIdentifier());
        if (result != 0) {
            return result;
        }
        String type1 = "";
        String type2 = "";
        IMarker marker1 = b1.getMarker();
        if (!marker1.exists()) {
            return 0;
        }
        try {
            type1 = marker1.getType();
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        try {
            IMarker marker2 = b2.getMarker();
            if (!marker2.exists()) {
                return 0;
            }
            type2 = marker2.getType();
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        result = type1.compareTo(type2);
        if (result != 0) {
            return result;
        }
        ILabelProvider lprov = (ILabelProvider)((StructuredViewer)viewer).getLabelProvider();
        String name1 = lprov.getText(e1);
        String name2 = lprov.getText(e2);
        boolean lineBreakpoint = false;
        try {
            lineBreakpoint = marker1.isSubtypeOf(IBreakpoint.LINE_BREAKPOINT_MARKER);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        if (lineBreakpoint) {
            return this.compareLineBreakpoints(b1, b2, name1, name2);
        }
        return name1.compareTo(name2);
    }

    protected int compareLineBreakpoints(IBreakpoint b1, IBreakpoint b2, String name1, String name2) {
        String upToColon1;
        int colon2;
        int colon1 = name1.indexOf(58);
        if (colon1 != -1 && (colon2 = name2.indexOf(58)) != -1 && name2.startsWith(upToColon1 = name1.substring(0, colon1))) {
            int l1 = 0;
            int l2 = 0;
            try {
                l1 = ((ILineBreakpoint)b1).getLineNumber();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            try {
                l2 = ((ILineBreakpoint)b2).getLineNumber();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            return l1 - l2;
        }
        return name1.compareTo(name2);
    }
}

