/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMInitializer;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.util.Util;

public class CreateInitializerOperation
extends CreateTypeMemberOperation {
    protected int fNumberOfInitializers = 1;

    public CreateInitializerOperation(IType parentElement, String source) {
        super(parentElement, source, false);
    }

    protected IDOMNode generateElementDOM() throws JavaModelException {
        if (this.fDOMNode == null) {
            this.fDOMNode = new DOMFactory().createInitializer(this.fSource);
            if (this.fDOMNode == null) {
                this.fDOMNode = this.generateSyntaxIncorrectDOM();
                if (this.fDOMNode == null) {
                    throw new JavaModelException(new JavaModelStatus(984));
                }
            }
        }
        if (!(this.fDOMNode instanceof IDOMInitializer)) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return this.fDOMNode;
    }

    protected IJavaElement generateResultHandle() {
        try {
            this.getType().getCompilationUnit().close();
            if (this.fAnchorElement == null) {
                return this.getType().getInitializer(this.fNumberOfInitializers);
            }
            IJavaElement[] children = this.getType().getChildren();
            int count = 0;
            for (int i = 0; i < children.length; ++i) {
                IJavaElement child = children[i];
                if (child.equals(this.fAnchorElement)) {
                    if (child.getElementType() == 10 && this.fInsertionPolicy == 2) {
                        ++count;
                    }
                    return this.getType().getInitializer(count);
                }
                if (child.getElementType() != 10) continue;
                ++count;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public String getMainTaskName() {
        return Util.bind("operation.createInitializerProgress");
    }

    protected void initializeDefaultPosition() {
        IType parentElement = this.getType();
        try {
            IJavaElement[] elements = parentElement.getInitializers();
            if (elements != null && elements.length > 0) {
                this.fNumberOfInitializers = elements.length;
                this.createAfter(elements[elements.length - 1]);
            } else {
                elements = parentElement.getChildren();
                if (elements != null && elements.length > 0) {
                    this.createBefore(elements[0]);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

