/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class SiteLocalModel
extends ModelObject {
    public static final String CONFIG_FILE = "platform.xml";
    private long stamp;
    private String label;
    private URL location;
    private String locationURLString;
    private int history = UpdateCore.DEFAULT_HISTORY;
    private List configurations;
    private List preservedConfigurations;
    private InstallConfigurationModel currentConfiguration;

    public InstallConfigurationModel getCurrentConfigurationModel() {
        return this.currentConfiguration;
    }

    public InstallConfigurationModel[] getConfigurationHistoryModel() {
        if (this.configurations == null) {
            this.processHistory();
        }
        if (this.configurations == null || this.configurations.size() == 0) {
            return new InstallConfigurationModel[0];
        }
        return (InstallConfigurationModel[])this.configurations.toArray(this.arrayTypeFor(this.configurations));
    }

    public void addConfigurationModel(InstallConfigurationModel config) {
        if (config != null) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            if (!this.configurations.contains((Object)config)) {
                this.configurations.add(config);
            }
        }
    }

    public boolean removeConfigurationModel(InstallConfigurationModel config) {
        if (config != null) {
            return this.configurations.remove((Object)config);
        }
        return false;
    }

    public URL getLocationURL() {
        return this.location;
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public void setLocationURLString(String locationURLString) {
        this.assertIsWriteable();
        this.locationURLString = locationURLString;
        this.location = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.assertIsWriteable();
        this.label = label;
    }

    public int getMaximumHistoryCount() {
        return this.history;
    }

    public void setMaximumHistoryCount(int history) {
        this.assertIsWriteable();
        this.history = history;
    }

    public void addPreservedInstallConfigurationModel(InstallConfigurationModel configuration) {
        if (this.preservedConfigurations == null) {
            this.preservedConfigurations = new ArrayList();
        }
        this.preservedConfigurations.add(configuration);
    }

    public boolean removePreservedConfigurationModel(InstallConfigurationModel configuration) {
        if (this.preservedConfigurations != null) {
            return this.preservedConfigurations.remove((Object)configuration);
        }
        return false;
    }

    public InstallConfigurationModel[] getPreservedConfigurationsModel() {
        if (this.preservedConfigurations == null || this.preservedConfigurations.isEmpty()) {
            return new InstallConfigurationModel[0];
        }
        return (InstallConfigurationModel[])this.preservedConfigurations.toArray(this.arrayTypeFor(this.preservedConfigurations));
    }

    public void setCurrentConfigurationModel(InstallConfigurationModel currentConfiguration) {
        this.assertIsWriteable();
        this.currentConfiguration = currentConfiguration;
        ConfiguredSiteModel[] confSites = currentConfiguration.getConfigurationSitesModel();
        for (int i = 0; i < confSites.length; ++i) {
            confSites[i].getSiteModel().setConfiguredSiteModel(confSites[i]);
        }
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.location = this.resolveURL(base, bundleURL, this.getLocationURLString());
        this.resolveListReference(this.getConfigurationHistoryModel(), base, bundleURL);
        this.resolveListReference(this.getPreservedConfigurationsModel(), base, bundleURL);
        this.resolveReference(this.getCurrentConfigurationModel(), base, bundleURL);
    }

    public long getStamp() {
        return this.stamp;
    }

    public void setStamp(long stamp) {
        this.stamp = stamp;
    }

    protected String getPropertyName() {
        return "platform";
    }

    private void processHistory() {
        try {
            URL historyURL = new URL(this.getLocationURL(), "history");
            historyURL = Platform.asLocalURL((URL)historyURL);
            File historyDir = new File(historyURL.getFile());
            if (historyDir.exists()) {
                File[] backedConfigs = historyDir.listFiles();
                BaseSiteLocalFactory factory = new BaseSiteLocalFactory();
                for (int i = 0; i < backedConfigs.length; ++i) {
                    String name = backedConfigs[i].getName();
                    if (!name.endsWith(".xml")) continue;
                    name = name.substring(0, name.length() - 4);
                    Date date = new Date(Long.parseLong(name));
                    InstallConfigurationModel config = factory.createInstallConfigurationModel();
                    config.setLocationURLString(backedConfigs[i].getAbsolutePath().replace('\\', '/'));
                    config.setLabel(date.toString());
                    config.setCreationDate(date);
                    config.resolve(backedConfigs[i].toURL(), this.getResourceBundleURL());
                    this.addConfigurationModel(config);
                }
            }
        }
        catch (Exception e) {
            UpdateCore.warn("Error processing history: ", e);
        }
    }

    URL getResourceBundleURL() throws CoreException {
        URL url = null;
        try {
            url = UpdateManagerUtils.asDirectoryURL(this.getLocationURL());
        }
        catch (MissingResourceException e) {
            UpdateCore.warn(e.getLocalizedMessage() + ":" + url.toExternalForm());
        }
        catch (MalformedURLException e) {
            UpdateCore.warn(e.getLocalizedMessage());
        }
        return url;
    }
}

