/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdi.internal.ArrayReferenceImpl;
import org.eclipse.jdi.internal.BooleanValueImpl;
import org.eclipse.jdi.internal.ByteValueImpl;
import org.eclipse.jdi.internal.CharValueImpl;
import org.eclipse.jdi.internal.ClassLoaderReferenceImpl;
import org.eclipse.jdi.internal.ClassObjectReferenceImpl;
import org.eclipse.jdi.internal.DoubleValueImpl;
import org.eclipse.jdi.internal.FloatValueImpl;
import org.eclipse.jdi.internal.IntegerValueImpl;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.LongValueImpl;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdi.internal.PrimitiveTypeImpl;
import org.eclipse.jdi.internal.PrimitiveValueImpl;
import org.eclipse.jdi.internal.ShortValueImpl;
import org.eclipse.jdi.internal.StringReferenceImpl;
import org.eclipse.jdi.internal.ThreadGroupReferenceImpl;
import org.eclipse.jdi.internal.ThreadReferenceImpl;
import org.eclipse.jdi.internal.TypeImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VoidValueImpl;
import org.eclipse.jdi.internal.jdwp.JdwpID;
import org.eclipse.jdi.internal.jdwp.JdwpObjectID;

public abstract class ValueImpl
extends MirrorImpl
implements Value {
    protected ValueImpl(String description, VirtualMachineImpl vmImpl) {
        super(description, vmImpl);
    }

    public abstract Type type();

    public abstract byte getTag();

    public static ValueImpl readWithTag(MirrorImpl target, DataInputStream in) throws IOException {
        byte tag = target.readByte("object tag", JdwpID.tagMap(), in);
        return ValueImpl.readWithoutTag(target, tag, in);
    }

    public static ValueImpl readWithoutTag(MirrorImpl target, int type, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        switch (type) {
            case 91: {
                return ArrayReferenceImpl.read(target, in);
            }
            case 108: {
                return ClassLoaderReferenceImpl.read(target, in);
            }
            case 99: {
                return ClassObjectReferenceImpl.read(target, in);
            }
            case 115: {
                return StringReferenceImpl.read(target, in);
            }
            case 76: {
                return ObjectReferenceImpl.readObjectRefWithoutTag(target, in);
            }
            case 103: {
                return ThreadGroupReferenceImpl.read(target, in);
            }
            case 116: {
                return ThreadReferenceImpl.read(target, in);
            }
            case 90: {
                return BooleanValueImpl.read(target, in);
            }
            case 66: {
                return ByteValueImpl.read(target, in);
            }
            case 67: {
                return CharValueImpl.read(target, in);
            }
            case 68: {
                return DoubleValueImpl.read(target, in);
            }
            case 70: {
                return FloatValueImpl.read(target, in);
            }
            case 73: {
                return IntegerValueImpl.read(target, in);
            }
            case 74: {
                return LongValueImpl.read(target, in);
            }
            case 83: {
                return ShortValueImpl.read(target, in);
            }
            case 86: {
                return new VoidValueImpl(vmImpl);
            }
            case 0: {
                return null;
            }
        }
        throw new InternalException(JDIMessages.getString("ValueImpl.Invalid_Value_tag_encountered___1") + type);
    }

    public void writeWithTag(MirrorImpl target, DataOutputStream out) throws IOException {
        target.writeByte(this.getTag(), "tag", JdwpID.tagMap(), out);
        this.write(target, out);
    }

    public abstract void write(MirrorImpl var1, DataOutputStream var2) throws IOException;

    public static void writeNull(MirrorImpl target, DataOutputStream out) throws IOException {
        JdwpObjectID nullID = new JdwpObjectID(target.virtualMachineImpl());
        nullID.write(out);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("objectReference", nullID.value());
        }
    }

    public static void writeNullWithTag(MirrorImpl target, DataOutputStream out) throws IOException {
        target.writeByte((byte)76, "tag", JdwpID.tagMap(), out);
        ValueImpl.writeNull(target, out);
    }

    protected static List checkValues(List values, List types, VirtualMachineImpl vm) throws InvalidTypeException {
        ArrayList<ValueImpl> result = new ArrayList<ValueImpl>(values.size());
        Iterator iterValues = values.iterator();
        Iterator iterTypes = types.iterator();
        while (iterValues.hasNext()) {
            Value value = (Value)iterValues.next();
            Type type = (Type)iterTypes.next();
            result.add(ValueImpl.checkValue(value, type, vm));
        }
        return result;
    }

    protected static ValueImpl checkValue(Value value, Type type, VirtualMachineImpl vm) throws InvalidTypeException {
        if (value == null) {
            if (type instanceof PrimitiveType) {
                throw new InvalidTypeException(JDIMessages.getString("ValueImpl.Type_of_the_value_not_compatible_with_the_expected_type._1"));
            }
            return null;
        }
        vm.checkVM(value);
        TypeImpl valueType = (TypeImpl)value.type();
        if (type instanceof PrimitiveType ^ valueType instanceof PrimitiveType) {
            throw new InvalidTypeException(JDIMessages.getString("ValueImpl.Type_of_the_value_not_compatible_with_the_expected_type._1"));
        }
        if (type instanceof PrimitiveType) {
            return ValueImpl.checkPrimitiveValue((PrimitiveValueImpl)value, (PrimitiveTypeImpl)valueType, (PrimitiveTypeImpl)type);
        }
        return (ValueImpl)value;
    }

    protected static ValueImpl checkPrimitiveValue(PrimitiveValueImpl value, PrimitiveTypeImpl valueType, PrimitiveTypeImpl type) throws InvalidTypeException {
        char typeSignature;
        char valueTypeSignature = valueType.signature().charAt(0);
        if (valueTypeSignature == (typeSignature = type.signature().charAt(0))) {
            return value;
        }
        VirtualMachineImpl vm = value.virtualMachineImpl();
        switch (typeSignature) {
            case 'D': {
                if (valueTypeSignature == 'Z') break;
                return new DoubleValueImpl(vm, new Double(value.doubleValue()));
            }
            case 'F': {
                if (valueTypeSignature == 'Z' || valueTypeSignature == 'D') break;
                return new FloatValueImpl(vm, new Float(value.floatValue()));
            }
            case 'J': {
                if (valueTypeSignature == 'Z' || valueTypeSignature == 'D' || valueTypeSignature == 'F') break;
                return new LongValueImpl(vm, new Long(value.longValue()));
            }
            case 'I': {
                if (valueTypeSignature != 'B' && valueTypeSignature != 'C' && valueTypeSignature != 'S') break;
                return new IntegerValueImpl(vm, new Integer(value.intValue()));
            }
            case 'S': {
                if (valueTypeSignature != 'B') break;
                return new ShortValueImpl(vm, new Short(value.shortValue()));
            }
        }
        throw new InvalidTypeException(JDIMessages.getString("ValueImpl.Type_of_the_value_not_compatible_with_the_expected_type._1"));
    }
}

