/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core;

import com.sun.jdi.VirtualMachineManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.core.ListenerList;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.hcr.JavaHotCodeReplaceManager;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.osgi.framework.BundleContext;

public class JDIDebugPlugin
extends Plugin
implements Preferences.IPropertyChangeListener {
    public static final int INTERNAL_ERROR = 120;
    private static JDIDebugPlugin fgPlugin;
    private ListenerList fBreakpointListeners = null;
    private static final int ADDING = 1;
    private static final int INSTALLED = 2;
    private static final int REMOVED = 3;
    private static final int COMPILATION_ERRORS = 4;
    private static final int RUNTIME_EXCEPTION = 5;
    private boolean fTrace = false;
    private static int[] fJDIVersion;

    public boolean isTraceMode() {
        return this.fTrace;
    }

    public static void logTraceMessage(String message) {
        if (JDIDebugPlugin.getDefault().isTraceMode()) {
            Status s = new Status(2, JDIDebugPlugin.getUniqueIdentifier(), 120, message, null);
            JDIDebugPlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    public static JDIDebugPlugin getDefault() {
        return fgPlugin;
    }

    public static String getUniqueIdentifier() {
        return "org.eclipse.jdt.debug";
    }

    public static int[] getJDIVersion() {
        if (fJDIVersion == null) {
            fJDIVersion = new int[2];
            VirtualMachineManager mgr = Bootstrap.virtualMachineManager();
            JDIDebugPlugin.fJDIVersion[0] = mgr.majorInterfaceVersion();
            JDIDebugPlugin.fJDIVersion[1] = mgr.minorInterfaceVersion();
        }
        return fJDIVersion;
    }

    public static boolean isJdiVersionGreaterThanOrEqual(int[] version) {
        int[] runningVersion = JDIDebugPlugin.getJDIVersion();
        return runningVersion[0] > version[0] || runningVersion[0] == version[0] && runningVersion[1] >= version[1];
    }

    public JDIDebugPlugin() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JavaHotCodeReplaceManager.getDefault().startup();
        this.fBreakpointListeners = new ListenerList(5);
    }

    public void addHotCodeReplaceListener(IJavaHotCodeReplaceListener listener) {
        JavaHotCodeReplaceManager.getDefault().addHotCodeReplaceListener(listener);
    }

    public void removeHotCodeReplaceListener(IJavaHotCodeReplaceListener listener) {
        JavaHotCodeReplaceManager.getDefault().removeHotCodeReplaceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            this.savePluginPreferences();
            JavaHotCodeReplaceManager.getDefault().shutdown();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            IDebugTarget[] targets = launchManager.getDebugTargets();
            for (int i = 0; i < targets.length; ++i) {
                IDebugTarget target = targets[i];
                if (!(target instanceof JDIDebugTarget)) continue;
                ((JDIDebugTarget)target).shutdown();
            }
            this.fBreakpointListeners = null;
        }
        finally {
            fgPlugin = null;
            super.stop(context);
        }
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        JDIDebugPlugin.log((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, "Internal error logged from JDI Debug: ", top));
    }

    public static void logDebugMessage(String message) {
        if (JDIDebugPlugin.getDefault().isDebugging()) {
            JDIDebugPlugin.log((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, "Internal message logged from JDI Debug: " + message, null));
        }
    }

    public static void log(IStatus status) {
        JDIDebugPlugin.getDefault().getLog().log(status);
    }

    public void fireBreakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
        this.getBreakpointNotifier().notify(null, breakpoint, 4, errors, null);
    }

    public void fireBreakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
        this.getBreakpointNotifier().notify(null, breakpoint, 5, null, exception);
    }

    public void addJavaBreakpointListener(IJavaBreakpointListener listener) {
        this.fBreakpointListeners.add((Object)listener);
    }

    public void removeJavaBreakpointListener(IJavaBreakpointListener listener) {
        this.fBreakpointListeners.remove((Object)listener);
    }

    public void fireBreakpointAdding(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
        this.getBreakpointNotifier().notify(target, breakpoint, 1, null, null);
    }

    public void fireBreakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
        this.getBreakpointNotifier().notify(target, breakpoint, 2, null, null);
    }

    public void fireBreakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
        this.getBreakpointNotifier().notify(target, breakpoint, 3, null, null);
    }

    public boolean fireBreakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        return this.getHitNotifier().notifyHit(thread, breakpoint);
    }

    public boolean fireInstalling(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        return this.getInstallingNotifier().notifyInstalling(target, breakpoint, type);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals(JDIDebugModel.PREF_REQUEST_TIMEOUT)) {
            this.savePluginPreferences();
            int value = this.getPluginPreferences().getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT);
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            for (int i = 0; i < targets.length; ++i) {
                if (!(targets[i] instanceof IJavaDebugTarget)) continue;
                ((IJavaDebugTarget)targets[i]).setRequestTimeout(value);
            }
        }
    }

    private BreakpointNotifier getBreakpointNotifier() {
        return new BreakpointNotifier();
    }

    private InstallingNotifier getInstallingNotifier() {
        return new InstallingNotifier();
    }

    private HitNotifier getHitNotifier() {
        return new HitNotifier();
    }

    protected void initializeDefaultPluginPreferences() {
        super.initializeDefaultPluginPreferences();
        Preferences prefs = this.getPluginPreferences();
        prefs.setDefault(JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000);
        prefs.setDefault(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, true);
        prefs.setDefault(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION, true);
        prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    static {
        fJDIVersion = null;
    }

    class HitNotifier
    implements ISafeRunnable {
        private IJavaThread fThread;
        private IJavaBreakpoint fBreakpoint;
        private IJavaBreakpointListener fListener;
        private int fSuspend;

        HitNotifier() {
        }

        public void handleException(Throwable exception) {
        }

        public void run() throws Exception {
            this.fSuspend |= this.fListener.breakpointHit(this.fThread, this.fBreakpoint);
        }

        public boolean notifyHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
            this.fThread = thread;
            this.fBreakpoint = breakpoint;
            Object[] listeners = JDIDebugPlugin.this.fBreakpointListeners.getListeners();
            this.fSuspend = 4;
            for (int i = 0; i < listeners.length; ++i) {
                this.fListener = (IJavaBreakpointListener)listeners[i];
                Platform.run((ISafeRunnable)this);
            }
            this.fThread = null;
            this.fBreakpoint = null;
            this.fListener = null;
            return (this.fSuspend & 1) > 0 || (this.fSuspend & 2) == 0;
        }
    }

    class InstallingNotifier
    implements ISafeRunnable {
        private IJavaDebugTarget fTarget;
        private IJavaBreakpoint fBreakpoint;
        private IJavaType fType;
        private IJavaBreakpointListener fListener;
        private int fInstall;

        InstallingNotifier() {
        }

        public void handleException(Throwable exception) {
        }

        public void run() throws Exception {
            this.fInstall |= this.fListener.installingBreakpoint(this.fTarget, this.fBreakpoint, this.fType);
        }

        private void dispose() {
            this.fTarget = null;
            this.fBreakpoint = null;
            this.fType = null;
            this.fListener = null;
        }

        public boolean notifyInstalling(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
            this.fTarget = target;
            this.fBreakpoint = breakpoint;
            this.fType = type;
            this.fInstall = 4;
            Object[] listeners = JDIDebugPlugin.this.fBreakpointListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                this.fListener = (IJavaBreakpointListener)listeners[i];
                Platform.run((ISafeRunnable)this);
            }
            this.dispose();
            return (this.fInstall & 1) > 0 || (this.fInstall & 2) == 0;
        }
    }

    class BreakpointNotifier
    implements ISafeRunnable {
        private IJavaDebugTarget fTarget;
        private IJavaBreakpoint fBreakpoint;
        private int fKind;
        private Message[] fErrors;
        private DebugException fException;
        private IJavaBreakpointListener fListener;

        BreakpointNotifier() {
        }

        public void handleException(Throwable exception) {
        }

        public void run() throws Exception {
            switch (this.fKind) {
                case 1: {
                    this.fListener.addingBreakpoint(this.fTarget, this.fBreakpoint);
                    break;
                }
                case 2: {
                    this.fListener.breakpointInstalled(this.fTarget, this.fBreakpoint);
                    break;
                }
                case 3: {
                    this.fListener.breakpointRemoved(this.fTarget, this.fBreakpoint);
                    break;
                }
                case 4: {
                    this.fListener.breakpointHasCompilationErrors((IJavaLineBreakpoint)this.fBreakpoint, this.fErrors);
                    break;
                }
                case 5: {
                    this.fListener.breakpointHasRuntimeException((IJavaLineBreakpoint)this.fBreakpoint, this.fException);
                }
            }
        }

        public void notify(IJavaDebugTarget target, IJavaBreakpoint breakpoint, int kind, Message[] errors, DebugException exception) {
            this.fTarget = target;
            this.fBreakpoint = breakpoint;
            this.fKind = kind;
            this.fErrors = errors;
            this.fException = exception;
            Object[] listeners = JDIDebugPlugin.this.fBreakpointListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                this.fListener = (IJavaBreakpointListener)listeners[i];
                Platform.run((ISafeRunnable)this);
            }
            this.fTarget = null;
            this.fBreakpoint = null;
            this.fErrors = null;
            this.fException = null;
            this.fListener = null;
        }
    }
}

