/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import org.eclipse.compare.internal.ResizableDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.ui.ISaveableWorkbenchPart;

public class SaveablePartDialog
extends ResizableDialog {
    private ISaveableWorkbenchPart input;
    private Button saveButton;

    public SaveablePartDialog(Shell shell, ISaveableWorkbenchPart input) {
        super(shell, null);
        this.input = input;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.input.createPartControl(parent);
        Shell shell = this.getShell();
        shell.setText(this.input.getTitle());
        shell.setImage(this.input.getTitleImage());
        Dialog.applyDialogFont((Control)parent2);
        return parent;
    }

    public boolean close() {
        this.saveChanges();
        return super.close();
    }

    private void saveChanges() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Policy.bind("ParticipantCompareDialog.2"), null, Policy.bind("ParticipantCompareDialog.3"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (this.input.isDirty() && dialog.open() == 2) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    SaveablePartDialog.this.input.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
    }
}

