/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.util.Enumeration;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IHex;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class ShowTileCommand
extends ServerCommand {
    public ShowTileCommand(Server server) {
        super(server, "tile", "print the information about a tile into the chat window. Ussage: /tile 01 01 whih would show the details for the hex numbered 01 01.");
    }

    public void run(int n, String[] stringArray) {
        try {
            int n2 = 3;
            String string = "";
            Coords coords = new Coords(Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]) - 1);
            do {
                IHex iHex;
                if ((iHex = this.server.getGame().getBoard().getHex(coords)) != null) {
                    Enumeration<Entity> enumeration;
                    string = "Details for hex (" + (coords.x + 1) + ", " + (coords.y + 1) + ") : " + iHex.toString();
                    if (!this.server.getGame().getOptions().booleanOption("double_blind") && (enumeration = this.server.getGame().getEntities(coords)).hasMoreElements()) {
                        string = string + "; Contains entities: " + enumeration.nextElement().getId();
                        while (enumeration.hasMoreElements()) {
                            string = string + ", " + enumeration.nextElement().getId();
                        }
                    }
                    this.server.sendServerChat(n, string);
                } else {
                    this.server.sendServerChat(n, "Hex (" + (coords.x + 1) + ", " + (coords.y + 1) + ") is not on the board.");
                }
                if (n2 >= stringArray.length) continue;
                coords = coords.translated(stringArray[n2]);
            } while (++n2 < stringArray.length);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

