/*
 * generated by Xtext
 */
package net.sourceforge.ufoai.formatting;

import net.sourceforge.ufoai.services.UFOScriptGrammarAccess;

import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.util.Pair;

/**
 * This class contains custom formatting description. see :
 * http://www.eclipse.org/Xtext/documentation/latest/xtext.html#formatting on
 * how and when to use it Also see
 * {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
public class UFOScriptFormatter extends AbstractDeclarativeFormatter {
	@Override
	protected void configureFormatting(FormattingConfig cfg) {
		UFOScriptGrammarAccess g = (UFOScriptGrammarAccess) getGrammarAccess();
		cfg.setAutoLinewrap(120);

		// find common keywords an specify formatting for them
		for (Pair<Keyword, Keyword> pair : g.findKeywordPairs("(", ")")) {
			cfg.setNoSpace().after(pair.getFirst());
			cfg.setNoSpace().before(pair.getSecond());
		}
		for (Pair<Keyword, Keyword> pair : g.findKeywordPairs("{", "}")) {
			cfg.setIndentation(pair.getFirst(), pair.getSecond());
		}
		for (Keyword comma : g.findKeywords(",")) {
			cfg.setNoSpace().before(comma);
			cfg.setSpace(" ").after(comma);
		}

		cfg.setLinewrap().after(g.getUFONodeRule());

		// formatting for Comments
		cfg.setLinewrap(0, 1, 2).before(g.getSL_COMMENTRule());
		cfg.setLinewrap(0, 1, 2).before(g.getML_COMMENTRule());
		cfg.setLinewrap(0, 1, 1).after(g.getML_COMMENTRule());
	}
}
