#include "translate.h"

static const t_unicode koi8_ru_c1_chars[] = {
0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524, /* 0x80-0x87 */
0x252C, 0x2534, 0x253C, 0x2580, 0x2584, 0x2588, 0x258C, 0x2590, /* 0x88-0x8F */
0x2591, /* 0x90 - LIGHT SHADE */
0x2592, /* 0x91 - MEDIUM SHADE */
0x2593, /* 0x92 - DARK SHADE */
0x201C, /* 0x93 - LEFT DOUBLE QUOTATION MARK */
0x25A0, /* 0x94 - BLACK SQUARE */
0x2219, /* 0x95 - BULLET OPERATOR */
0x201D, /* 0x96 - RIGHT DOUBLE QUOTATION MARK */
0x2014, /* 0x97 - EM DASH */
0x2116, /* 0x98 - NUMERO SIGN */
0x2122, /* 0x99 - TRADE MARK SIGN */
0x00A0, /* 0x9A - NO-BREAK SPACE */
0x00BB, /* 0x9B - RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
0x00AE, /* 0x9C - REGISTERED SIGN */
0x00AB, /* 0x9D - LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
0x00B7, /* 0x9E - MIDDLE DOT */
0x00A4  /* 0x9F - CURRENCY SIGN */
};

struct char_set koi8_ru_c1 = {
	1,
	CHARS(koi8_ru_c1_chars),
	0, "", 0, 32,
};

static const t_unicode koi8_ru_g1_chars[] = {
0x2550, /* 0xA0 - BOX DRAWINGS DOUBLE HORIZONTAL */
0x2551, /* 0xA1 - BOX DRAWINGS DOUBLE VERTICAL */
0x2552, /* 0xA2 - BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE */
0x0451, /* 0xA3 - CYRILLIC SMALL LETTER IO */
0x0454, /* 0xA4 - CYRILLIC SMALL LETTER UKRAINIAN IE */
0x2554, /* 0xA5 - BOX DRAWINGS DOUBLE DOWN AND RIGHT */
0x0456, /* 0xA6 - CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
0x0457, /* 0xA7 - CYRILLIC SMALL LETTER YI */
0x2557, /* 0xA8 - BOX DRAWINGS DOUBLE DOWN AND LEFT */
0x2558, /* 0xA9 - BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE */
0x2559, /* 0xAA - BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE */
0x255A, /* 0xAB - BOX DRAWINGS DOUBLE UP AND RIGHT */
0x255B, /* 0xAC - BOX DRAWINGS UP SINGLE AND LEFT DOUBLE */
0x0491, /* 0xAD - CYRILLIC SMALL LETTER GHE WITH UPTURN */
0x045E, /* 0xAE - CYRILLIC SMALL LETTER SHORT U */
0x255E, /* 0xAF - BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */
0x255F, /* 0xB0 - BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE */
0x2560, /* 0xB1 - BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
0x2561, /* 0xB2 - BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */
0x0401, /* 0xB3 - CYRILLIC CAPITAL LETTER IO */
0x0404, /* 0xB4 - CYRILLIC CAPITAL LETTER UKRAINIAN IE */
0x2563, /* 0xB5 - BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
0x0406, /* 0xB6 - CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
0x0407, /* 0xB7 - CYRILLIC CAPITAL LETTER YI */
0x2566, /* 0xB8 - BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
0x2567, /* 0xB9 - BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE */
0x2568, /* 0xBA - BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE */
0x2569, /* 0xBB - BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
0x256A, /* 0xBC - BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */
0x0490, /* 0xBD - CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
0x040E, /* 0xBE - CYRILLIC CAPITAL LETTER SHORT U */
0x00A9, /* 0xBF - COPYRIGHT SIGN */
0x044E, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, /* 0xC0-0xC7 */
0x0445, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, /* 0xC8-0xCF */
0x043F, 0x044F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, /* 0xD0-0xD7 */
0x044C, 0x044B, 0x0437, 0x0448, 0x044D, 0x0449, 0x0447, 0x044A, /* 0xD8-0xDF */
0x042E, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, /* 0xE0-0xE7 */
0x0425, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, /* 0xE8-0xEF */
0x041F, 0x042F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, /* 0xF0-0xF7 */
0x042C, 0x042B, 0x0417, 0x0428, 0x042D, 0x0429, 0x0427, 0x042A  /* 0xF8-0xFF */
};

struct char_set koi8_ru_g1 = {
	1,
	CHARS(koi8_ru_g1_chars),
	0, "", 1, 96,
};

struct char_set koi8_ru = {
	.c0 = &ascii_c0,
	.g0 = &ascii_g0,
	.c1 = &koi8_ru_c1,
	.g1 = &koi8_ru_g1,
	.names = { "koi8-ru", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&koi8_ru);
}
