/*
 * Decompiled with CFR 0.152.
 */
package jrm.compressors;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import jrm.compressors.Archive;
import jrm.compressors.SevenZipOptions;
import jrm.compressors.ZipOptions;
import jrm.misc.Settings;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.IOutCreateArchive;
import net.sf.sevenzipjbinding.IOutCreateCallback;
import net.sf.sevenzipjbinding.IOutFeatureSetLevel;
import net.sf.sevenzipjbinding.IOutFeatureSetMultithreading;
import net.sf.sevenzipjbinding.IOutFeatureSetSolid;
import net.sf.sevenzipjbinding.IOutItemAllFormats;
import net.sf.sevenzipjbinding.IOutUpdateArchive;
import net.sf.sevenzipjbinding.ISequentialInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.SevenZipNativeInitializationException;
import net.sf.sevenzipjbinding.impl.OutItemFactory;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.impl.RandomAccessFileOutStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

abstract class NArchive
implements Archive {
    private File archive;
    private File tempDir = null;
    private final boolean readonly;
    private IInArchive iinarchive = null;
    private IInStream iinstream = null;
    private static HashMap<String, File> archives = new HashMap();
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    private final List<String> to_add = new ArrayList<String>();
    private final HashSet<String> to_delete = new HashSet();
    private final HashMap<String, String> to_rename = new HashMap();
    private final HashMap<String, String> to_duplicate = new HashMap();
    private ArchiveFormat format = ArchiveFormat.SEVEN_ZIP;
    private String ext = "7z";

    public NArchive(File archive) throws IOException, SevenZipNativeInitializationException {
        this(archive, false);
    }

    public NArchive(File archive, boolean readonly) throws IOException, SevenZipNativeInitializationException {
        if (!SevenZip.isInitializedSuccessfully()) {
            SevenZip.initSevenZipFromPlatformJAR((File)Settings.getTmpPath(true).toFile());
        }
        this.ext = FilenameUtils.getExtension(archive.getName());
        if (archive.exists()) {
            this.iinstream = new RandomAccessFileInStream(new RandomAccessFile(archive, "r"));
            this.closeables.add((Closeable)this.iinstream);
            this.iinarchive = SevenZip.openInArchive(null, (IInStream)this.iinstream);
            this.closeables.add((Closeable)this.iinarchive);
            this.format = this.iinarchive.getArchiveFormat();
        } else {
            switch (this.ext.toLowerCase()) {
                case "zip": {
                    this.format = ArchiveFormat.ZIP;
                    break;
                }
                default: {
                    this.format = ArchiveFormat.SEVEN_ZIP;
                }
            }
        }
        this.readonly = readonly;
        this.archive = archives.get(archive.getAbsolutePath());
        if (null == this.archive) {
            this.archive = archive;
            archives.put(archive.getAbsolutePath(), this.archive);
        }
    }

    @Override
    public void close() throws IOException {
        if (!(this.to_add.isEmpty() && this.to_rename.isEmpty() && this.to_delete.isEmpty() && this.to_duplicate.isEmpty())) {
            Iterator<Closeable> raf3;
            final HashMap rafs = new HashMap();
            final HashMap tmpfiles = new HashMap();
            IOutCreateCallback<IOutItemAllFormats> callback = new IOutCreateCallback<IOutItemAllFormats>(){
                HashMap<Integer, String> idx_to_delete = new HashMap();
                HashMap<Integer, String> idx_to_rename = new HashMap();
                ArrayList<Object[]> idx_to_duplicate = new ArrayList();
                int old_idx = 0;
                int old_tot = 0;
                {
                    if (NArchive.this.iinarchive != null) {
                        this.old_tot = NArchive.this.iinarchive.getNumberOfItems();
                        for (int i = 0; i < this.old_tot; ++i) {
                            String path = NArchive.this.iinarchive.getProperty(i, PropID.PATH).toString();
                            for (String string : NArchive.this.to_delete) {
                                if (!path.equals(string)) continue;
                                this.idx_to_delete.put(i, string);
                                break;
                            }
                            for (Map.Entry entry : NArchive.this.to_rename.entrySet()) {
                                if (!path.equals(entry.getKey())) continue;
                                this.idx_to_rename.put(i, (String)entry.getValue());
                                break;
                            }
                            for (Map.Entry entry : NArchive.this.to_duplicate.entrySet()) {
                                if (!path.equals(entry.getValue())) continue;
                                this.idx_to_duplicate.add(new Object[]{i, entry.getKey(), null});
                            }
                        }
                        if (NArchive.this.to_delete.size() != this.idx_to_delete.size()) {
                            System.err.println("to_delete:" + NArchive.this.to_delete.size() + "!=" + this.idx_to_delete.size());
                        }
                        if (NArchive.this.to_rename.size() != this.idx_to_rename.size()) {
                            System.err.println("to_rename:" + NArchive.this.to_rename.size() + "!=" + this.idx_to_rename.size());
                        }
                        if (NArchive.this.to_duplicate.size() != this.idx_to_duplicate.size()) {
                            System.err.println("to_duplicate:" + NArchive.this.to_duplicate.size() + "!=" + this.idx_to_duplicate.size());
                        }
                    }
                }

                public void setTotal(long total) throws SevenZipException {
                }

                public void setCompleted(long complete) throws SevenZipException {
                }

                public void setOperationResult(boolean operationResultOk) throws SevenZipException {
                }

                public ISequentialInStream getStream(int index) throws SevenZipException {
                    if (index + this.idx_to_delete.size() - this.old_tot < NArchive.this.to_add.size()) {
                        try {
                            rafs.put(index, new RandomAccessFile(new File(NArchive.this.getTempDir(), (String)NArchive.this.to_add.get(index + this.idx_to_delete.size() - this.old_tot)), "r"));
                            return new RandomAccessFileInStream((RandomAccessFile)rafs.get(index));
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (index + this.idx_to_delete.size() - this.old_tot - NArchive.this.to_add.size() < NArchive.this.to_duplicate.size()) {
                        try {
                            if (!rafs.containsKey(index)) {
                                HashMap<Integer, File> tmpfiles_by_oldindex = new HashMap<Integer, File>();
                                final HashMap rafs2 = new HashMap();
                                for (Object[] objectArray : this.idx_to_duplicate) {
                                    if (!tmpfiles_by_oldindex.containsKey(objectArray[0])) {
                                        tmpfiles_by_oldindex.put((Integer)objectArray[0], Files.createTempFile("JRM", null, new FileAttribute[0]).toFile());
                                    }
                                    tmpfiles.put((Integer)objectArray[2], tmpfiles_by_oldindex.get(objectArray[0]));
                                }
                                for (Map.Entry entry : tmpfiles_by_oldindex.entrySet()) {
                                    rafs2.put(entry.getKey(), new RandomAccessFile((File)entry.getValue(), "rw"));
                                }
                                int[] indices = this.idx_to_duplicate.stream().flatMapToInt(objs -> IntStream.of((int)((Integer)objs[0]))).toArray();
                                NArchive.this.iinarchive.extract(indices, false, new IArchiveExtractCallback(){

                                    public void setTotal(long total) throws SevenZipException {
                                    }

                                    public void setCompleted(long complete) throws SevenZipException {
                                    }

                                    public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
                                    }

                                    public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
                                    }

                                    public ISequentialOutStream getStream(int idx, ExtractAskMode extractAskMode) throws SevenZipException {
                                        if (ExtractAskMode.EXTRACT == extractAskMode) {
                                            return new RandomAccessFileOutStream((RandomAccessFile)rafs2.get(idx));
                                        }
                                        return null;
                                    }
                                });
                                for (RandomAccessFile randomAccessFile : rafs2.values()) {
                                    randomAccessFile.close();
                                }
                                for (Map.Entry entry : tmpfiles.entrySet()) {
                                    rafs.put(entry.getKey(), new RandomAccessFile((File)entry.getValue(), "r"));
                                }
                            }
                            ((RandomAccessFile)rafs.get(index)).seek(0L);
                            return new RandomAccessFileInStream((RandomAccessFile)rafs.get(index));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IOutItemAllFormats getItemInformation(int index, OutItemFactory<IOutItemAllFormats> outItemFactory) throws SevenZipException {
                    try {
                        while (this.idx_to_delete.containsKey(this.old_idx)) {
                            ++this.old_idx;
                        }
                        if (this.idx_to_rename.containsKey(this.old_idx)) {
                            IOutItemAllFormats item = (IOutItemAllFormats)outItemFactory.createOutItemAndCloneProperties(this.old_idx);
                            item.setPropertyPath(this.idx_to_rename.get(this.old_idx));
                            IOutItemAllFormats iOutItemAllFormats = item;
                            return iOutItemAllFormats;
                        }
                        if (this.old_idx < this.old_tot) {
                            IOutItemAllFormats item = (IOutItemAllFormats)outItemFactory.createOutItem(this.old_idx);
                            return item;
                        }
                        if (this.old_idx - this.old_tot < NArchive.this.to_add.size()) {
                            String file = (String)NArchive.this.to_add.get(this.old_idx - this.old_tot);
                            IOutItemAllFormats item = (IOutItemAllFormats)outItemFactory.createOutItem();
                            item.setPropertyPath(file);
                            try {
                                item.setDataSize(Long.valueOf(new File(NArchive.this.getTempDir(), file).length()));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            item.setUpdateIsNewData(Boolean.valueOf(true));
                            item.setUpdateIsNewProperties(Boolean.valueOf(true));
                            IOutItemAllFormats e = item;
                            return e;
                        }
                        Object[] objects = this.idx_to_duplicate.get(this.old_idx - this.old_tot - NArchive.this.to_add.size());
                        ISimpleInArchiveItem ref_item = NArchive.this.iinarchive.getSimpleInterface().getArchiveItem(((Integer)objects[0]).intValue());
                        objects[2] = index;
                        IOutItemAllFormats item = (IOutItemAllFormats)outItemFactory.createOutItem();
                        item.setPropertyPath((String)objects[1]);
                        item.setDataSize(ref_item.getSize());
                        item.setUpdateIsNewData(Boolean.valueOf(true));
                        item.setUpdateIsNewProperties(Boolean.valueOf(true));
                        IOutItemAllFormats iOutItemAllFormats = item;
                        return iOutItemAllFormats;
                    }
                    finally {
                        ++this.old_idx;
                    }
                }
            };
            if (this.archive.exists() && this.iinarchive != null) {
                File tmpfile = Files.createTempFile(this.archive.getParentFile().toPath(), "JRM", "." + this.ext, new FileAttribute[0]).toFile();
                tmpfile.delete();
                raf3 = new RandomAccessFile(tmpfile, "rw");
                Throwable throwable = null;
                try {
                    IOutUpdateArchive iout = this.iinarchive.getConnectedOutArchive();
                    this.SetOptions(iout);
                    int itemsCount = this.iinarchive.getNumberOfItems() - this.to_delete.size() + this.to_add.size() + this.to_duplicate.size();
                    iout.updateItems((ISequentialOutStream)new RandomAccessFileOutStream((RandomAccessFile)((Object)raf3)), itemsCount, (IOutCreateCallback)callback);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (raf3 != null) {
                        if (throwable != null) {
                            try {
                                ((RandomAccessFile)((Object)raf3)).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((RandomAccessFile)((Object)raf3)).close();
                        }
                    }
                }
                for (Closeable c : this.closeables) {
                    c.close();
                }
                this.closeables.clear();
                if (tmpfile.exists() && tmpfile.length() > 0L) {
                    this.archive.delete();
                    if (!tmpfile.renameTo(this.archive)) {
                        tmpfile.delete();
                    }
                }
            } else {
                IOutCreateArchive iout = SevenZip.openOutArchive((ArchiveFormat)this.format);
                raf3 = null;
                try (RandomAccessFile raf2 = new RandomAccessFile(this.archive, "rw");){
                    this.SetOptions(iout);
                    int itemsCount = this.to_add.size() + this.to_duplicate.size();
                    iout.createArchive((ISequentialOutStream)new RandomAccessFileOutStream(raf2), itemsCount, (IOutCreateCallback)callback);
                }
                catch (Throwable throwable) {
                    raf3 = throwable;
                    throw throwable;
                }
                finally {
                    if (iout != null) {
                        if (raf3 != null) {
                            try {
                                iout.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)raf3)).addSuppressed(throwable);
                            }
                        } else {
                            iout.close();
                        }
                    }
                }
                for (Closeable c : this.closeables) {
                    c.close();
                }
                this.closeables.clear();
            }
            for (Iterator<Closeable> raf3 : rafs.values()) {
                ((RandomAccessFile)((Object)raf3)).close();
            }
            for (File tmpfile : tmpfiles.values()) {
                tmpfile.delete();
            }
        } else {
            for (Closeable c : this.closeables) {
                c.close();
            }
            this.closeables.clear();
        }
        try {
            if (this.tempDir != null) {
                FileUtils.deleteDirectory(this.tempDir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void SetOptions(Object iout) throws SevenZipException {
        switch (this.format) {
            case SEVEN_ZIP: {
                if (iout instanceof IOutFeatureSetSolid) {
                    ((IOutFeatureSetSolid)iout).setSolid(Settings.getProperty("7z_solid", true));
                }
                if (iout instanceof IOutFeatureSetLevel) {
                    ((IOutFeatureSetLevel)iout).setLevel(SevenZipOptions.valueOf(Settings.getProperty("7z_level", SevenZipOptions.NORMAL.toString())).getLevel());
                }
                if (!(iout instanceof IOutFeatureSetMultithreading)) break;
                ((IOutFeatureSetMultithreading)iout).setThreadCount(Settings.getProperty("7z_threads", -1));
                break;
            }
            case ZIP: {
                if (iout instanceof IOutFeatureSetLevel) {
                    ((IOutFeatureSetLevel)iout).setLevel(ZipOptions.valueOf(Settings.getProperty("zip_level", ZipOptions.NORMAL.toString())).getLevel());
                }
                if (!(iout instanceof IOutFeatureSetMultithreading)) break;
                ((IOutFeatureSetMultithreading)iout).setThreadCount(Settings.getProperty("zip_threads", -1));
            }
        }
    }

    @Override
    public File getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDirectory("JRM", new FileAttribute[0]).toFile();
        }
        return this.tempDir;
    }

    private int extract(File baseDir, String entry) throws IOException {
        ISimpleInArchive simpleInArchive = this.iinarchive.getSimpleInterface();
        for (ISimpleInArchiveItem item : simpleInArchive.getArchiveItems()) {
            if (!item.getPath().equals(entry)) continue;
            try (RandomAccessFile out = new RandomAccessFile(new File(baseDir, entry), "rw");){
                if (item.extractSlow((ISequentialOutStream)new RandomAccessFileOutStream(out)) != ExtractOperationResult.OK) continue;
                int n = 0;
                return n;
            }
        }
        return -1;
    }

    @Override
    public File extract(String entry) throws IOException {
        this.extract(this.getTempDir(), entry);
        File result = new File(this.getTempDir(), entry);
        if (result.exists()) {
            return result;
        }
        return null;
    }

    @Override
    public InputStream extract_stdout(String entry) throws IOException {
        this.extract(this.getTempDir(), entry);
        return new FileInputStream(new File(this.getTempDir(), entry));
    }

    @Override
    public int add(File baseDir, String entry) throws IOException {
        if (this.readonly) {
            return -1;
        }
        if (!baseDir.equals(this.getTempDir())) {
            FileUtils.copyFile(new File(baseDir, entry), new File(this.getTempDir(), entry));
        }
        this.to_add.add(entry);
        return 0;
    }

    @Override
    public int add_stdin(InputStream src, String entry) throws IOException {
        if (this.readonly) {
            return -1;
        }
        FileUtils.copyInputStreamToFile(src, new File(this.getTempDir(), entry));
        this.to_add.add(entry);
        return 0;
    }

    @Override
    public int delete(String entry) throws IOException {
        if (this.readonly) {
            return -1;
        }
        this.to_delete.add(this.normalize(entry));
        return 0;
    }

    @Override
    public int rename(String entry, String newname) throws IOException {
        if (this.readonly) {
            return -1;
        }
        this.to_rename.put(this.normalize(entry), this.normalize(newname));
        return 0;
    }

    @Override
    public int duplicate(String entry, String newname) throws IOException {
        if (this.readonly) {
            return -1;
        }
        this.to_duplicate.put(this.normalize(newname), this.normalize(entry));
        return 0;
    }

    private String normalize(String entry) {
        if (File.separatorChar == '/') {
            return entry.replace('\\', '/');
        }
        return entry.replace('/', '\\');
    }
}

