/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import jrm.compressors.zipfs.ZipFileSystemProvider;
import jrm.misc.Settings;
import jrm.profile.data.Container;
import jrm.profile.data.Entry;
import jrm.profile.fix.actions.BackupEntry;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.fix.actions.EntryAction;
import jrm.profile.scan.options.FormatOptions;
import jrm.ui.progress.ProgressHandler;

public class BackupContainer
extends ContainerAction {
    private static Map<String, FileSystem> filesystems = new HashMap<String, FileSystem>();

    public BackupContainer(Container container) {
        super(container, FormatOptions.ZIP);
    }

    public static BackupContainer getInstance(BackupContainer action, Container container) {
        if (action == null) {
            action = new BackupContainer(container);
        }
        return action;
    }

    public static synchronized FileSystem getFS(Container container, EntryAction action) throws IOException {
        String crc2 = action.entry.crc.substring(0, 2);
        if (!filesystems.containsKey(crc2)) {
            File workdir = Settings.getWorkPath().toFile();
            File backupdir = new File(workdir, "backup");
            CRC32 crc = new CRC32();
            crc.update(container.file.getAbsoluteFile().getParent().getBytes());
            File backupfile = new File(new File(backupdir, String.format("%08x", crc.getValue())), crc2 + ".zip");
            backupfile.getParentFile().mkdirs();
            HashMap<String, Object> env = new HashMap<String, Object>();
            if (!backupfile.exists()) {
                env.put("create", "true");
            }
            env.put("useTempFile", true);
            env.put("compressionLevel", 1);
            filesystems.put(crc2, new ZipFileSystemProvider().newFileSystem(URI.create("zip:" + backupfile.toURI()), env));
        }
        return filesystems.get(crc2);
    }

    public static void closeAllFS() {
        filesystems.values().forEach(fs -> {
            try {
                FileSystem fileSystem = fs;
                synchronized (fileSystem) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        filesystems.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doAction(ProgressHandler handler) {
        try {
            int i = 0;
            if (this.entry_actions.size() == 0) {
                for (Entry entry : this.container.getEntries()) {
                    this.addAction(new BackupEntry(entry));
                }
            }
            for (EntryAction action : this.entry_actions) {
                FileSystem fs;
                ++i;
                FileSystem fileSystem = fs = BackupContainer.getFS(this.container, action);
                synchronized (fileSystem) {
                    if (!action.doAction(fs, handler, i, this.entry_actions.size())) {
                        System.err.println("action to " + this.container.file.getName() + "@" + action.entry.file + " failed");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }
}

