/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.spockframework.gentyref.GenericTypeReflector;
import org.spockframework.mock.IMockMethod;
import org.spockframework.util.ReflectionUtil;

public class DynamicMockMethod
implements IMockMethod {
    private final String methodName;
    private final List<Type> parameterTypes;
    Type returnType;
    private final boolean isStatic;

    public DynamicMockMethod(String methodName, int argumentCount, boolean isStatic) {
        this(methodName, (List<Type>)Collections.nCopies(argumentCount, Object.class), (Type)((Object)Object.class), isStatic);
    }

    public DynamicMockMethod(String methodName, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.isStatic = isStatic;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public List<Class<?>> getParameterTypes() {
        return ReflectionUtil.eraseTypes(this.getExactParameterTypes());
    }

    @Override
    public List<Type> getExactParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?> getReturnType() {
        return GenericTypeReflector.erase(this.returnType);
    }

    @Override
    public Type getExactReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }
}

