/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import groovy.lang.Closure;
import org.spockframework.lang.ConditionBlock;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.SpockTimeoutError;

public class PollingConditions {
    private double timeout = 1.0;
    private double initialDelay = 0.0;
    private double delay = 0.1;
    private double factor = 1.0;

    public double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(double seconds) {
        this.timeout = seconds;
    }

    public double getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(double seconds) {
        this.initialDelay = seconds;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double seconds) {
        this.delay = seconds;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    @ConditionBlock
    public void eventually(Closure<?> conditions) throws InterruptedException {
        this.within(this.timeout, conditions);
    }

    @ConditionBlock
    public void within(double seconds, Closure<?> conditions) throws InterruptedException {
        long timeoutMillis = this.toMillis(seconds);
        long start = System.currentTimeMillis();
        long lastAttempt = 0L;
        Thread.sleep(this.toMillis(this.initialDelay));
        long currDelay = this.toMillis(this.delay);
        int attempts = 0;
        while (true) {
            try {
                ++attempts;
                lastAttempt = System.currentTimeMillis();
                GroovyRuntimeUtil.invokeClosure(conditions, new Object[0]);
                return;
            }
            catch (AssertionError e) {
                long elapsedTime = lastAttempt - start;
                if (elapsedTime >= timeoutMillis) {
                    String msg = String.format("Condition not satisfied after %1.2f seconds and %d attempts", (double)elapsedTime / 1000.0, attempts);
                    throw new SpockTimeoutError(seconds, msg, (Throwable)((Object)e));
                }
                Thread.sleep(Math.min(currDelay, start + timeoutMillis - System.currentTimeMillis()));
                currDelay = (long)((double)currDelay * this.factor);
                continue;
            }
            break;
        }
    }

    @ConditionBlock
    public void call(Closure<?> conditions) throws InterruptedException {
        this.eventually(conditions);
    }

    @ConditionBlock
    public void call(double seconds, Closure<?> conditions) throws InterruptedException {
        this.within(seconds, conditions);
    }

    private long toMillis(double seconds) {
        return (long)(seconds * 1000.0);
    }
}

