/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;

class SpellNodeDataView
implements DataView<SpellSupportFacade.SuperNode> {
    private final List<? extends DataViewColumn> columns;
    private final String prefsKey;
    private final InfoFactory infoFactory;

    public SpellNodeDataView(boolean initiallyVisible, String prefsKey, InfoFactory infoFactory) {
        this.prefsKey = prefsKey;
        this.infoFactory = infoFactory;
        this.columns = Arrays.asList(new DefaultDataViewColumn("School", String.class, initiallyVisible), new DefaultDataViewColumn("Subschool", String.class, initiallyVisible), new DefaultDataViewColumn("Descriptors", String.class, initiallyVisible), new DefaultDataViewColumn("Components", String.class, initiallyVisible), new DefaultDataViewColumn("in_descrip", String.class, initiallyVisible), new DefaultDataViewColumn("Range", String.class), new DefaultDataViewColumn("Duration", String.class), new DefaultDataViewColumn("Source", String.class), new DefaultDataViewColumn("Cast Time", String.class));
    }

    @Override
    public List<?> getData(SpellSupportFacade.SuperNode obj) {
        if (obj instanceof SpellSupportFacade.SpellNode) {
            SpellFacade spell = ((SpellSupportFacade.SpellNode)obj).getSpell();
            if (spell == null) {
                return Arrays.asList(null, null, null, null, null, null, null);
            }
            return Arrays.asList(spell.getSchool(), spell.getSubschool(), StringUtils.join((Object[])spell.getDescriptors(), ", "), spell.getComponents(), this.infoFactory.getDescription(spell), spell.getRange(), spell.getDuration(), spell.getSource(), spell.getCastTime());
        }
        return Arrays.asList(null, null, null, null, null, null, null);
    }

    @Override
    public List<? extends DataViewColumn> getDataColumns() {
        return this.columns;
    }

    @Override
    public String getPrefsKey() {
        return this.prefsKey;
    }
}

