/*
 * Decompiled with CFR 0.152.
 */
package plugin.encounter;

import gmgen.io.ReadXML;
import java.io.File;
import java.lang.reflect.Array;
import javax.swing.DefaultListModel;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;

public class EncounterModel
extends DefaultListModel {
    private String dir;
    private PlayerCharacter[] PCs;

    public EncounterModel(String parentDir) {
        this.dir = parentDir;
    }

    public int getCR() {
        File f = new File(this.dir + File.separator + "4_1.xml");
        float cr = 0.0f;
        ReadXML xml = new ReadXML(f);
        xml.getTable();
        for (int i = 0; i < this.size(); ++i) {
            Race aRace = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Race.class, (String)this.elementAt(i));
            ChallengeRating rcr = aRace.get(ObjectKey.CHALLENGE_RATING);
            if (rcr == null) continue;
            cr += this.mCRtoPL(rcr.getRating().resolveStatic().floatValue());
        }
        if ((cr = (float)this.mPLtoCR(cr)) < 0.0f) {
            cr = 0.0f;
        }
        return (int)((double)cr + 0.5);
    }

    public void setPCs(int len) {
        this.PCs = (PlayerCharacter[])Array.newInstance(PlayerCharacter.class, len);
        for (int x = 0; x < len; ++x) {
            this.PCs[x] = new PlayerCharacter();
        }
    }

    public PlayerCharacter[] getPCs() {
        return this.PCs;
    }

    public float mCRtoPL(float x) {
        float iReturn = 0.0f;
        iReturn = x < 1.0f ? x : (float)Math.exp((x - 1.0f) / 2.0f);
        return iReturn;
    }

    public int mPLtoCR(float x) {
        return (int)(2.0 * Math.log(x) + 1.0);
    }
}

