/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class GamemodeToken
extends AbstractTokenWithSeparator<Campaign>
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "GAMEMODE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Campaign campaign, String gameMode) {
        context.getObjectContext().removeList((CDOMObject)campaign, ListKey.GAME_MODE);
        StringTokenizer aTok = new StringTokenizer(gameMode, "|");
        while (aTok.hasMoreTokens()) {
            context.getObjectContext().addToList((CDOMObject)campaign, ListKey.GAME_MODE, (Object)aTok.nextToken());
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Campaign campaign) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)campaign, ListKey.GAME_MODE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            Logging.errorPrint((String)("Found Game Mode changes in " + campaign.getKeyName() + " but none were added"));
            return null;
        }
        return new String[]{StringUtil.join((Collection)added, (String)"|")};
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

