/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.Iterator;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.display.SkillDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class SkillListModsToken
extends Token {
    public static final String TOKENNAME = "SKILLLISTMODS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringBuilder returnString = new StringBuilder();
        boolean needcomma = false;
        List pcSkills = SkillDisplay.getSkillListInOutputOrder((PlayerCharacter)pc);
        Iterator iter = pcSkills.iterator();
        while (iter.hasNext()) {
            Skill sk = (Skill)iter.next();
            if (pc.includeSkill(sk, SkillFilter.Usable) && sk.qualifies(pc, null)) continue;
            iter.remove();
        }
        for (Skill aSkill : pcSkills) {
            int modSkill = -1;
            CDOMSingleRef statref = (CDOMSingleRef)aSkill.get(ObjectKey.KEY_STAT);
            if (statref != null) {
                modSkill = SkillModifier.modifier((Skill)aSkill, (PlayerCharacter)pc) - pc.getStatModFor((PCStat)statref.resolvesTo());
            }
            if (SkillRankControl.getTotalRank((PlayerCharacter)pc, (Skill)aSkill).intValue() <= 0 && modSkill <= 0) continue;
            int temp = SkillModifier.modifier((Skill)aSkill, (PlayerCharacter)pc) + SkillRankControl.getTotalRank((PlayerCharacter)pc, (Skill)aSkill).intValue();
            if (needcomma) {
                returnString.append(", ");
            }
            needcomma = true;
            returnString.append(OutputNameFormatting.getOutputName((CDOMObject)aSkill)).append(temp >= 0 ? " +" : " ").append(Integer.toString(temp));
        }
        return returnString.toString();
    }
}

