/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.ExcludeProcessor;
import com.eed3si9n.jarjar.Keep;
import com.eed3si9n.jarjar.KeepProcessor;
import com.eed3si9n.jarjar.ManifestProcessor;
import com.eed3si9n.jarjar.MethodSignatureProcessor;
import com.eed3si9n.jarjar.PackageRemapper;
import com.eed3si9n.jarjar.PatternElement;
import com.eed3si9n.jarjar.ResourceProcessor;
import com.eed3si9n.jarjar.Rule;
import com.eed3si9n.jarjar.Zap;
import com.eed3si9n.jarjar.ZapProcessor;
import com.eed3si9n.jarjar.misplaced.MisplacedClassProcessor;
import com.eed3si9n.jarjar.misplaced.MisplacedClassProcessorFactory;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.JarProcessor;
import com.eed3si9n.jarjar.util.JarProcessorChain;
import com.eed3si9n.jarjar.util.JarTransformerChain;
import com.eed3si9n.jarjar.util.RemappingClassTransformer;
import com.eed3si9n.jarjar.util.StandaloneJarProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MainProcessor
implements JarProcessor {
    private final boolean verbose;
    private final JarProcessorChain chain;
    private final KeepProcessor kp;
    private final Map<String, String> renames = new HashMap<String, String>();

    public MainProcessor(List<PatternElement> list2, boolean bl, boolean bl2) {
        this(list2, bl, bl2, null);
    }

    public MainProcessor(List<PatternElement> list2, boolean bl, boolean bl2, String string) {
        this.verbose = bl;
        ArrayList<Zap> arrayList = new ArrayList<Zap>();
        ArrayList<Rule> arrayList2 = new ArrayList<Rule>();
        ArrayList<Keep> arrayList3 = new ArrayList<Keep>();
        for (PatternElement object2 : list2) {
            if (object2 instanceof Zap) {
                arrayList.add((Zap)object2);
                continue;
            }
            if (object2 instanceof Rule) {
                arrayList2.add((Rule)object2);
                continue;
            }
            if (!(object2 instanceof Keep)) continue;
            arrayList3.add((Keep)object2);
        }
        PackageRemapper packageRemapper = new PackageRemapper(arrayList2, bl);
        this.kp = arrayList3.isEmpty() ? null : new KeepProcessor(arrayList3);
        ArrayList<JarProcessor> arrayList4 = new ArrayList<JarProcessor>();
        if (bl2) {
            arrayList4.add(ManifestProcessor.getInstance());
        }
        if (this.kp != null) {
            arrayList4.add(this.kp);
        }
        MisplacedClassProcessor misplacedClassProcessor = MisplacedClassProcessorFactory.getInstance().getProcessorForName(string);
        arrayList4.add(new ZapProcessor(arrayList));
        arrayList4.add(misplacedClassProcessor);
        arrayList4.add(new JarTransformerChain(new RemappingClassTransformer[]{new RemappingClassTransformer()}, packageRemapper));
        arrayList4.add(new MethodSignatureProcessor(packageRemapper));
        arrayList4.add(new ResourceProcessor(packageRemapper));
        this.chain = new JarProcessorChain(arrayList4.toArray(new JarProcessor[arrayList4.size()]));
    }

    public void strip(File file) throws IOException {
        if (this.kp == null) {
            return;
        }
        Set<String> set = this.getExcludes();
        if (!set.isEmpty()) {
            StandaloneJarProcessor.run(file, file, new ExcludeProcessor(set, this.verbose));
        }
    }

    private Set<String> getExcludes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.kp.getExcludes()) {
            String string2 = string + ".class";
            String string3 = this.renames.get(string2);
            hashSet.add(string3 != null ? string3 : string2);
        }
        return hashSet;
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        String string = entryStruct.name;
        boolean bl = this.chain.process(entryStruct);
        if (bl) {
            if (!string.equals(entryStruct.name)) {
                if (this.kp != null) {
                    this.renames.put(string, entryStruct.name);
                }
                if (this.verbose) {
                    System.err.println("Renamed " + string + " -> " + entryStruct.name);
                }
            }
        } else if (this.verbose) {
            System.err.println("Removed " + string);
        }
        return bl;
    }
}

