/* ex: set ts=4 noet: */

#ifndef UTIL_DEBUG_H
#define UTIL_DEBUG_H

#include "setup.h"
#include "types.h"
#if defined(WIN32) && !defined(TIGER)
	#include <windows.h>
#else
	#ifdef LINUX
		#include <time.h>
	#endif
#endif
#include <stdio.h>
#include <stdarg.h>

#ifdef _DEBUG
	#define DEBUG(file, line, msg) do { \
		ERRF("DEBUG: %s [%s:%d]\n", msg, file, line); \
	} while (0)
#else
	#define DEBUG(file, line, msg) do { } while (0)
#endif

/* regular output */
#undef PRINT
#ifndef UTIL_NOSTDOUT
	#define PRINT(msg) OUTF(msg)
#else
	#define PRINT(msg) do { } while(0)
#endif


#undef WARN
#ifndef UTIL_NOSTDOUT
	#define WARN(file, line, msg) do { \
		ERRF("WARNING: %s [%s:%d]\n", \
			msg, file, line); \
	} while (0)
#else
	#define WARN(file, line, msg) do { } while (0)
#endif

#undef ERROR
#ifdef UTIL_NOSTDOUT
	#define ERROR(file, line, msg) do { } while (0)
#else
	#define ERROR(file, line, msg) do { \
		ERRF("ERROR: %s [%s:%d]\n", \
			msg, file, line); \
	} while (0)
#endif

#undef FATAL
#ifndef UTIL_NOSTDOUT
	/* include timestamps */
	#define FATAL(file, line, msg) do { \
		ERRF("FATAL: %s [%s:%d]\n", msg, file, line); \
		} while (0)
#else
#define FATAL(file, line, msg) do { } while(0)
#endif

void DEBUGF(const char *file, unsigned int line, const char *format, ...);

void OUTF(const char *format, ...);
void ERRF(const char *format, ...);

void PRINTF(const char *format, ...);
void ERRORF(const char *file, unsigned int line, const char *format, ...);
void WARNF(const char *file, unsigned int line, const char *format, ...);
void FATALF(const char *file, unsigned int line, const char *format, ...);

void UNREACHABLE(const char *file, unsigned int line, const char *format, ...);
void IMPOSSIBLE(const char *file, unsigned int line, const char *format, ...);
void PROGRAMMER_OOPS(const char *file, unsigned int line, const char *format, ...);


/* underlying call all above make */
void _DEBUGF(const char *, unsigned int, const char *, const char *, va_list);
void _DEBUGF_NOTIME(const char *, unsigned int, const char *, const char *, va_list);
void _OUTF(const char *, va_list);
void _PRINTF(const char *, va_list);

#ifdef UTIL_NOSTDOUT
	#define OUTFLUSH()
	#define ERRFLUSH()
	#define FFLUSH(fh)
	#define FPUTS(str, fh)
#else
	#define OUTFLUSH()		fflush(stdout)
	#define ERRFLUSH()		fflush(stderr)
	#define FFLUSH(fh)		fflush(fh)
	#define FPUTS(str, fh)	fputs(str, fh)
#endif

#endif

