/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmDeviceComponent;
import org.me4se.impl.lcdui.FontInfo;
import org.me4se.impl.lcdui.PhysicalFont;
import org.me4se.impl.lcdui.WordWrap;

public class ScmTextComponent
extends ScmDeviceComponent {
    protected int constraints;
    protected int cx;
    protected int cy;
    protected Vector lines = new Vector();
    protected int maxSize;
    protected int y0;

    public ScmTextComponent(Item item, String type, boolean editable) {
        super(item, type, editable);
        this.lines.addElement("");
    }

    boolean check(char c) {
        switch (this.constraints & 0xFFFF) {
            case 3: {
                if ("/()#*- ".indexOf(c) != -1) {
                    return true;
                }
            }
            case 2: {
                return c >= '0' && c <= '9' || c == '-';
            }
            case 1: {
                return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || ".-_".indexOf(c) != -1;
            }
            case 4: {
                return true;
            }
        }
        return true;
    }

    public void doLayout() {
        int p1;
        int charPos = this.getCharPos();
        String text = this.getText();
        this.lines = new Vector();
        WordWrap ww = new WordWrap(this.getFontInfo().font, text, this.getWidth() == 0 ? 100 : this.getWidth());
        int p0 = 0;
        this.cx = 0;
        this.cy = 0;
        while ((p1 = ww.next()) != -1) {
            int chars = p1 - p0;
            if (charPos > chars) {
                charPos -= chars;
                ++this.cy;
            } else if (charPos > 0) {
                this.cx = charPos;
                charPos = 0;
            }
            String l = text.substring(p0, p1);
            this.lines.addElement(l);
            p0 = p1;
        }
        if (this.lines.size() == 0 || charPos > 0) {
            this.lines.addElement("");
        }
    }

    public int getCaretPosition() {
        return this.cx;
    }

    public int getCharPos() {
        int pos = this.cx;
        for (int i = 0; i < Math.min(this.cy, this.lines.size()); ++i) {
            pos += this.getLine(i) == null ? 0 : this.getLine(i).length();
        }
        return pos;
    }

    public int getConstraints() {
        return this.constraints;
    }

    String getLine(int n) {
        return (String)this.lines.elementAt(n);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, (this.getFocusable() ? 1 : this.lines.size()) * this.getFontInfo().height);
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.lines.size(); ++i) {
            buf.append((String)this.lines.elementAt(i));
        }
        return buf.toString();
    }

    public boolean keyPressed(String code) {
        if (code.equals("LEFT")) {
            if (this.cx > 0) {
                --this.cx;
            } else if (this.cy > 0) {
                --this.cy;
                this.cx = this.getLine(this.cy).length();
            }
            this.repaint();
            return true;
        }
        if (code.equals("RIGHT")) {
            if (this.cx < this.getLine(this.cy).length()) {
                ++this.cx;
            } else if (this.cy < this.lines.size() - 1) {
                ++this.cy;
                this.cx = 0;
            }
            this.repaint();
            return true;
        }
        if (code.equals("CLEAR")) {
            String line = this.getLine(this.cy);
            if (this.cx == 0 && this.cy > 0) {
                line = this.getLine(--this.cy);
                this.cx = line.length();
            }
            if (this.cx > 0) {
                line = line.substring(0, this.cx - 1) + line.substring(this.cx);
                --this.cx;
            }
            this.lines.setElementAt(line, this.cy);
            this.doLayout();
            this.repaint();
            return true;
        }
        if (code.equals("SPACE")) {
            return this.enterChar(' ');
        }
        if (code.length() == 1) {
            return this.enterChar(code.charAt(0));
        }
        return super.keyPressed(code);
    }

    public boolean enterChar(char c) {
        if ((this.constraints & 0x20000) != 0) {
            return false;
        }
        String line = this.getLine(this.cy);
        if (c >= ' ' && this.check(c)) {
            if (line.length() == this.maxSize) {
                return false;
            }
            line = line.substring(0, this.cx) + c + line.substring(this.cx);
            ++this.cx;
            this.lines.setElementAt(line, this.cy);
            if (this.getFontInfo().font.stringWidth(line) > this.getWidth()) {
                this.doLayout();
            }
        }
        this.repaint();
        return true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        FontInfo fi = this.getFontInfo();
        PhysicalFont pf = fi.font;
        g.setColor(fi.foreground);
        if (this.cy >= this.lines.size()) {
            this.cy = this.lines.size() - 1;
        }
        if (this.cy * pf.height - this.y0 >= this.getHeight()) {
            this.y0 = this.cy * pf.height;
        } else if (this.y0 > this.cy * pf.height) {
            this.y0 = this.cy * pf.height;
        }
        int y = -this.y0;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.getLine(i);
            if ((this.constraints & 0x10000) != 0) {
                line = this.toMask(line);
            }
            fi.drawString(g, line, 0, y + pf.ascent);
            if (i == this.cy && this.hasFocus() && (this.constraints & 0x20000) == 0) {
                if (this.cx > line.length()) {
                    this.cx = line.length();
                }
                int x = pf.stringWidth(line.substring(0, this.cx));
                g.fillRect(x, y, 2, pf.height);
            }
            y += pf.height;
        }
    }

    public void setConstraints(int constraints) {
        this.constraints = constraints;
    }

    public int setMaxSize(int i) {
        this.maxSize = i > 65536 ? 65536 : i;
        return this.maxSize;
    }

    public void setText(String text) {
        this.lines = new Vector();
        this.lines.addElement(text == null ? "" : text);
        this.invalidate();
        this.doLayout();
    }

    protected String toMask(String password) {
        int size = password.length();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buffer.append('*');
        }
        return buffer.toString();
    }
}

