/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.increment1gui;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import net.yura.domination.engine.RiskUtil;

public class PrintDialog {
    private static String printJobName = "Print Job";
    private static int numberOfPages = 1;

    public static void print() {
        PrinterJob pJob = PrinterJob.getPrinterJob();
        if (pJob.printDialog()) {
            pJob.setJobName(printJobName);
            Printer printer = new Printer();
            pJob.setPageable(printer);
            pJob.setPrintable(printer);
            try {
                pJob.print();
            }
            catch (PrinterException ex) {
                RiskUtil.printStackTrace(ex);
            }
        }
    }

    private static class Printer
    implements Pageable,
    Printable {
        private Printer() {
        }

        public int getNumberOfPages() {
            return numberOfPages;
        }

        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            PageFormat pf = new PageFormat();
            pf.setPaper(new Paper());
            return pf;
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            return this;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex >= numberOfPages) {
                return 1;
            }
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            int paperWidth = (int)pageFormat.getImageableWidth();
            int paperHeight = (int)pageFormat.getImageableHeight();
            return 0;
        }
    }
}

