/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.StageController;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J)\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0016\u00a2\u0006\u0002\u0010\u001bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/WholeWorldStageController;", "Lorg/jetbrains/kotlin/ir/declarations/StageController;", "()V", "currentDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getCurrentDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "setCurrentDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "currentStage", "", "getCurrentStage", "()I", "setCurrentStage", "(I)V", "index", "createSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "parentSignature", "restrictTo", "T", "declaration", "fn", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withInitialIr", "block", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "backend.js"})
public final class WholeWorldStageController
extends StageController {
    private int currentStage;
    @Nullable
    private IrDeclaration currentDeclaration;
    private int index;

    public WholeWorldStageController() {
        super(0, 1, null);
    }

    @Override
    public int getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(int n) {
        this.currentStage = n;
    }

    @Override
    @Nullable
    public IrDeclaration getCurrentDeclaration() {
        return this.currentDeclaration;
    }

    public void setCurrentDeclaration(@Nullable IrDeclaration irDeclaration2) {
        this.currentDeclaration = irDeclaration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T restrictTo(@NotNull IrDeclaration declaration, @NotNull Function0<? extends T> fn) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        IrDeclaration previousCurrentDeclaration = this.getCurrentDeclaration();
        int previousIndex = this.index;
        this.setCurrentDeclaration(declaration);
        this.index = 0;
        try {
            object = fn.invoke();
        }
        finally {
            this.setCurrentDeclaration(previousCurrentDeclaration);
            this.index = previousIndex;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withInitialIr(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int oldStage = this.getCurrentStage();
        this.setCurrentStage(0);
        IrDeclaration oldCurrentDeclaration = this.getCurrentDeclaration();
        this.setCurrentDeclaration(null);
        try {
            object = block.invoke();
        }
        finally {
            this.setCurrentStage(oldStage);
            this.setCurrentDeclaration(oldCurrentDeclaration);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public IdSignature createSignature(@NotNull IdSignature parentSignature) {
        Intrinsics.checkNotNullParameter((Object)parentSignature, (String)"parentSignature");
        int n = this.index;
        this.index = n + 1;
        return new IdSignature.LoweredDeclarationSignature(parentSignature, this.getCurrentStage(), n);
    }
}

