/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngineTextMatcherEditor<E>
extends TextMatcherEditor<E> {
    private final Set<Field<E>> fields = new HashSet<Field<E>>();

    public SearchEngineTextMatcherEditor() {
    }

    public SearchEngineTextMatcherEditor(TextFilterator<? super E> textFilterator) {
        super(textFilterator);
    }

    public void setFields(Set<Field<E>> fields) {
        this.fields.clear();
        this.fields.addAll(fields);
    }

    public Set<Field<E>> getFields() {
        return new HashSet<Field<E>>(this.fields);
    }

    public void refilter(String inputText) {
        SearchTerm[] filterTerms = TextMatchers.parse(inputText, this.getFields());
        this.setTextMatcher(new TextMatcher(filterTerms, this.getFilterator(), this.getMode(), this.getStrategy()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Field<E>
    implements Serializable {
        private final String name;
        private final TextFilterator<? super E> textFilterator;

        public Field(String name, TextFilterator<? super E> textFilterator) {
            if (name == null) {
                throw new IllegalArgumentException("name may not be null");
            }
            if (textFilterator == null) {
                throw new IllegalArgumentException("textFilterator may not be null");
            }
            this.name = name;
            this.textFilterator = textFilterator;
        }

        public String getName() {
            return this.name;
        }

        public TextFilterator<? super E> getTextFilterator() {
            return this.textFilterator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field2 = (Field)o;
            return this.name.equals(field2.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

