/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.text.StrBuilder;
import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.core.dependencies.http.entity.ByteArrayEntity;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseNetworkHelper;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulsePingSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseStatus;
import java.io.IOException;
import java.util.Date;

final class DefaultQuickPulsePingSender
implements QuickPulsePingSender {
    private static final String QP_BASE_URI = "https://rt.services.visualstudio.com/QuickPulseService.svc/";
    private final String quickPulsePingUri;
    private final ApacheSender apacheSender;
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private String pingPrefix;
    private long lastValidTransmission = 0L;

    public DefaultQuickPulsePingSender(ApacheSender apacheSender, String instanceName, String quickPulseId) {
        this.apacheSender = apacheSender;
        String ikey = TelemetryConfiguration.getActive().getInstrumentationKey();
        this.quickPulsePingUri = "https://rt.services.visualstudio.com/QuickPulseService.svc/ping?ikey=" + ikey;
        StrBuilder sb = new StrBuilder();
        sb.append("{");
        sb.append("\"Documents\": null,");
        sb.append("\"Instance\":\"" + instanceName + "\",");
        sb.append("\"InstrumentationKey\": null,");
        sb.append("\"InvariantVersion\": 2,");
        sb.append("\"MachineName\":\"" + instanceName + "\",");
        sb.append("\"Metrics\": null,");
        sb.append("\"StreamId\": \"" + quickPulseId + "\",");
        sb.append("\"Timestamp\": \"\\/Date(");
        this.pingPrefix = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QuickPulseStatus ping() {
        Date currentDate = new Date();
        HttpPost request = this.networkHelper.buildRequest(currentDate, this.quickPulsePingUri);
        ByteArrayEntity pingEntity = this.buildPingEntity(currentDate.getTime());
        request.setEntity(pingEntity);
        long sendTime = System.nanoTime();
        HttpResponse response = null;
        try {
            response = this.apacheSender.sendPostRequest(request);
            if (!this.networkHelper.isSuccess(response)) return this.onPingError(sendTime);
            QuickPulseStatus quickPulseResultStatus = this.networkHelper.getQuickPulseStatus(response);
            switch (quickPulseResultStatus) {
                case QP_IS_OFF: 
                case QP_IS_ON: {
                    this.lastValidTransmission = sendTime;
                    QuickPulseStatus quickPulseStatus = quickPulseResultStatus;
                    return quickPulseStatus;
                }
                case ERROR: {
                    return this.onPingError(sendTime);
                }
            }
            return this.onPingError(sendTime);
        }
        catch (IOException iOException) {
            return this.onPingError(sendTime);
        }
        finally {
            if (response != null) {
                this.apacheSender.dispose(response);
            }
        }
    }

    private ByteArrayEntity buildPingEntity(long timeInMillis) {
        StrBuilder sb = new StrBuilder(this.pingPrefix);
        sb.append(timeInMillis);
        sb.append(")\\/\",");
        sb.append("\"Version\":\"2.2.0-738\"");
        sb.append("}");
        ByteArrayEntity bae = new ByteArrayEntity(sb.toString().getBytes());
        return bae;
    }

    private QuickPulseStatus onPingError(long sendTime) {
        double timeFromLastValidTransmission = (double)(sendTime - this.lastValidTransmission) / 1.0E9;
        if (timeFromLastValidTransmission >= 60.0) {
            return QuickPulseStatus.ERROR;
        }
        return QuickPulseStatus.QP_IS_OFF;
    }
}

