/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.cli;

import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.collections.ObservableList;
import org.jabref.Globals;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fetcher.CrossRef;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.preferences.JabRefPreferences;

public class CrossrefFetcherEvaluator {
    private CrossrefFetcherEvaluator() {
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Globals.prefs = JabRefPreferences.getInstance();
        try (FileReader reader = new FileReader(args[0]);){
            BibtexParser parser = new BibtexParser(Globals.prefs.getImportFormatPreferences(), Globals.getFileUpdateMonitor());
            ParserResult result = parser.parse(reader);
            BibDatabase db = result.getDatabase();
            ObservableList<BibEntry> entries = db.getEntries();
            final AtomicInteger dois = new AtomicInteger();
            final AtomicInteger doiFound = new AtomicInteger();
            final AtomicInteger doiNew = new AtomicInteger();
            final AtomicInteger doiIdentical = new AtomicInteger();
            int total = entries.size();
            final CountDownLatch countDownLatch = new CountDownLatch(total);
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            for (final BibEntry entry : entries) {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        block10: {
                            Optional origDOI = entry.getField("doi").flatMap(DOI::parse);
                            if (origDOI.isPresent()) {
                                dois.incrementAndGet();
                                try {
                                    Optional crossrefDOI = new CrossRef().findIdentifier(entry);
                                    if (crossrefDOI.isPresent()) {
                                        doiFound.incrementAndGet();
                                        if (((DOI)origDOI.get()).getDOI().equalsIgnoreCase(((DOI)crossrefDOI.get()).getDOI())) {
                                            doiIdentical.incrementAndGet();
                                        } else {
                                            System.out.println("DOI not identical for : " + entry);
                                        }
                                        break block10;
                                    }
                                    System.out.println("DOI not found for: " + entry);
                                }
                                catch (FetcherException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                try {
                                    Optional crossrefDOI = new CrossRef().findIdentifier(entry);
                                    if (crossrefDOI.isPresent()) {
                                        System.out.println("New DOI found for: " + entry);
                                        doiNew.incrementAndGet();
                                    }
                                }
                                catch (FetcherException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        countDownLatch.countDown();
                    }
                });
            }
            countDownLatch.await();
            System.out.println("---------------------------------");
            System.out.println("Total DB size: " + total);
            System.out.println("Total DOIs: " + dois);
            System.out.println("DOIs found: " + doiFound);
            System.out.println("DOIs identical: " + doiIdentical);
            System.out.println("New DOIs found: " + doiNew);
            executorService.shutdown();
        }
    }
}

