/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.OSXCompatibleToolbar;
import org.jabref.gui.SidePaneManager;
import org.jabref.gui.actions.MnemonicAwareAction;

public abstract class SidePaneComponent
extends JPanel {
    protected final JButton close = new JButton(IconTheme.JabRefIcon.CLOSE.getSmallIcon());
    protected final SidePaneManager manager;
    protected BasePanel panel;

    public SidePaneComponent(SidePaneManager manager, Icon icon, String title) {
        super(new BorderLayout());
        this.manager = manager;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.close.setMargin(new Insets(0, 0, 0, 0));
        this.close.setBorder(null);
        this.close.addActionListener(e -> this.hideAway());
        JButton up = new JButton(IconTheme.JabRefIcon.UP.getSmallIcon());
        up.setMargin(new Insets(0, 0, 0, 0));
        up.setBorder(null);
        up.addActionListener(e -> this.moveUp());
        JButton down = new JButton(IconTheme.JabRefIcon.DOWN.getSmallIcon());
        down.setMargin(new Insets(0, 0, 0, 0));
        down.setBorder(null);
        down.addActionListener(e -> this.moveDown());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)new JLabel(icon), "West");
        JLabel titleLabel = new JLabel(title);
        titleLabel.setOpaque(true);
        titleLabel.setForeground(new Color(79, 95, 143));
        titlePanel.add((Component)titleLabel, "Center");
        OSXCompatibleToolbar toolbar = new OSXCompatibleToolbar();
        ((Container)toolbar).add(up);
        ((Container)toolbar).add(down);
        ((Container)toolbar).add(this.close);
        toolbar.setOpaque(false);
        toolbar.setFloatable(false);
        titlePanel.add((Component)toolbar, "East");
        this.add((Component)titlePanel, "North");
    }

    public void setContentContainer(JPanel panel) {
        this.add((Component)panel, "Center");
    }

    private void hideAway() {
        this.manager.hideComponent(this);
    }

    private void moveUp() {
        this.manager.moveUp(this);
    }

    private void moveDown() {
        this.manager.moveDown(this);
    }

    public void setActiveBasePanel(BasePanel panel) {
        this.panel = panel;
    }

    public BasePanel getActiveBasePanel() {
        return this.panel;
    }

    public void componentClosing() {
    }

    public void componentOpening() {
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public abstract int getRescalingWeight();

    public abstract ToggleAction getToggleAction();

    public class ToggleAction
    extends MnemonicAwareAction {
        public ToggleAction(String text, String description, KeyStroke key, IconTheme.JabRefIcon icon) {
            super(icon.getIcon());
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", description);
        }

        public ToggleAction(String text, String description, KeyStroke key, Icon icon) {
            super(icon);
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SidePaneComponent.this.manager.hasComponent(SidePaneComponent.this.getClass())) {
                SidePaneComponent.this.manager.register(SidePaneComponent.this);
            }
            if ((e.getModifiers() & 0x10) != 0) {
                SidePaneComponent.this.manager.toggle(SidePaneComponent.this.getClass());
            } else {
                SidePaneComponent.this.manager.toggleThreeWay(SidePaneComponent.this.getClass());
            }
            this.putValue("SwingSelectedKey", SidePaneComponent.this.manager.isComponentVisible(SidePaneComponent.this.getClass()));
        }

        public void setSelected(boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }

        public boolean isSelected() {
            return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
        }
    }
}

