/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.dbproperties;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.SaveOrderConfigDisplay;
import org.jabref.gui.cleanup.FieldFormatterCleanupsPanel;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.logic.cleanup.Cleanups;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Encodings;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.shared.DatabaseLocation;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.metadata.SaveOrderConfig;

public class DatabasePropertiesDialog
extends JabRefDialog {
    private MetaData metaData;
    private BasePanel panel;
    private final JComboBox<Charset> encoding;
    private final JButton ok;
    private final JButton cancel;
    private final JTextField fileDir = new JTextField(40);
    private final JTextField fileDirIndv = new JTextField(40);
    private String oldFileVal = "";
    private String oldFileIndvVal = "";
    private SaveOrderConfig oldSaveOrderConfig;
    private JRadioButton saveInOriginalOrder;
    private JRadioButton saveInSpecifiedOrder;
    private final JCheckBox protect = new JCheckBox(Localization.lang("Refuse to save the library before external changes have been reviewed.", new String[0]));
    private boolean oldProtectVal;
    private SaveOrderConfigDisplay saveOrderPanel;
    private FieldFormatterCleanupsPanel fieldFormatterCleanupsPanel;

    public DatabasePropertiesDialog(JFrame parent) {
        super((Frame)parent, Localization.lang("Library properties", new String[0]), true, DatabasePropertiesDialog.class);
        this.encoding = new JComboBox();
        this.encoding.setModel(new DefaultComboBoxModel<Charset>(Encodings.ENCODINGS));
        this.ok = new JButton(Localization.lang("OK", new String[0]));
        this.cancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.init();
    }

    public void setPanel(BasePanel panel) {
        this.panel = panel;
        this.metaData = panel.getBibDatabaseContext().getMetaData();
    }

    public void updateEnableStatus() {
        DatabaseLocation location = this.panel.getBibDatabaseContext().getLocation();
        boolean isShared = location == DatabaseLocation.SHARED;
        this.encoding.setEnabled(!isShared);
        this.saveInOriginalOrder.setEnabled(!isShared);
        this.saveInSpecifiedOrder.setEnabled(!isShared);
        this.saveOrderPanel.setEnabled(!isShared);
        this.protect.setEnabled(!isShared);
    }

    private void init() {
        DirectoryDialogConfiguration directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        FXDialogService ds = new FXDialogService();
        JButton browseFile = new JButton(Localization.lang("Browse", new String[0]));
        JButton browseFileIndv = new JButton(Localization.lang("Browse", new String[0]));
        browseFile.addActionListener(e -> DefaultTaskExecutor.runInJavaFXThread(() -> ds.showDirectorySelectionDialog(directoryDialogConfiguration)).ifPresent(f -> this.fileDir.setText(f.toAbsolutePath().toString())));
        browseFileIndv.addActionListener(e -> DefaultTaskExecutor.runInJavaFXThread(() -> ds.showDirectorySelectionDialog(directoryDialogConfiguration)).ifPresent(f -> this.fileDirIndv.setText(f.toAbsolutePath().toString())));
        this.setupSortOrderConfiguration();
        FormLayout form = new FormLayout("left:pref, 4dlu, pref:grow, 4dlu, pref:grow, 4dlu, pref", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, fill:pref:grow, 180dlu, fill:pref:grow,");
        FormBuilder builder = FormBuilder.create().layout(form);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.add(Localization.lang("Library encoding", new String[0]), new Object[0]).xy(1, 1);
        builder.add(this.encoding).xy(3, 1);
        builder.addSeparator(Localization.lang("Override default file directories", new String[0]), new Object[0]).xyw(1, 3, 5);
        builder.add(Localization.lang("General file directory", new String[0]), new Object[0]).xy(1, 5);
        builder.add(this.fileDir).xy(3, 5);
        builder.add(browseFile).xy(5, 5);
        builder.add(Localization.lang("User-specific file directory", new String[0]), new Object[0]).xy(1, 7);
        builder.add(this.fileDirIndv).xy(3, 7);
        builder.add(browseFileIndv).xy(5, 7);
        builder.addSeparator(Localization.lang("Save sort order", new String[0]), new Object[0]).xyw(1, 13, 5);
        builder.add(this.saveInOriginalOrder).xyw(1, 15, 5);
        builder.add(this.saveInSpecifiedOrder).xyw(1, 17, 5);
        this.saveOrderPanel = new SaveOrderConfigDisplay();
        builder.add(this.saveOrderPanel.getPanel()).xyw(1, 21, 5);
        builder.addSeparator(Localization.lang("Library protection", new String[0]), new Object[0]).xyw(1, 23, 5);
        builder.add(this.protect).xyw(1, 25, 5);
        this.fieldFormatterCleanupsPanel = new FieldFormatterCleanupsPanel(Localization.lang("Enable save actions", new String[0]), Cleanups.DEFAULT_SAVE_ACTIONS);
        builder.addSeparator(Localization.lang("Save actions", new String[0]), new Object[0]).xyw(1, 27, 5);
        builder.add(this.fieldFormatterCleanupsPanel).xyw(1, 29, 5);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addRelatedGap();
        bb.addButton((JComponent)new HelpAction(HelpFile.DATABASE_PROPERTIES).getHelpButton());
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabasePropertiesDialog.this.dispose();
            }
        };
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
        this.ok.addActionListener(e -> {
            if (this.propertiesChanged()) {
                this.storeSettings();
            }
            this.dispose();
        });
        this.cancel.addActionListener(e -> this.dispose());
    }

    private boolean propertiesChanged() {
        Charset oldEncoding = this.panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding());
        Charset newEncoding = (Charset)this.encoding.getSelectedItem();
        boolean saveActionsChanged = this.fieldFormatterCleanupsPanel.hasChanged();
        boolean saveOrderConfigChanged = !this.getNewSaveOrderConfig().equals(this.oldSaveOrderConfig);
        boolean changed = saveOrderConfigChanged || !newEncoding.equals(oldEncoding) || !this.oldFileVal.equals(this.fileDir.getText()) || !this.oldFileIndvVal.equals(this.fileDirIndv.getText()) || this.oldProtectVal != this.protect.isSelected() || saveActionsChanged;
        return changed;
    }

    private SaveOrderConfig getNewSaveOrderConfig() {
        SaveOrderConfig saveOrderConfig = null;
        if (this.saveInOriginalOrder.isSelected()) {
            saveOrderConfig = SaveOrderConfig.getDefaultSaveOrder();
        } else {
            saveOrderConfig = this.saveOrderPanel.getSaveOrderConfig();
            saveOrderConfig.setSaveInSpecifiedOrder();
        }
        return saveOrderConfig;
    }

    private void setupSortOrderConfiguration() {
        this.saveInOriginalOrder = new JRadioButton(Localization.lang("Save entries in their original order", new String[0]));
        this.saveInSpecifiedOrder = new JRadioButton(Localization.lang("Save entries ordered as specified", new String[0]));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.saveInOriginalOrder);
        bg.add(this.saveInSpecifiedOrder);
        ActionListener listener = e -> {
            boolean selected = e.getSource() == this.saveInSpecifiedOrder;
            this.saveOrderPanel.setEnabled(selected);
        };
        this.saveInOriginalOrder.addActionListener(listener);
        this.saveInSpecifiedOrder.addActionListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setValues();
        }
        super.setVisible(visible);
    }

    private void setValues() {
        boolean selected;
        Optional<Charset> charset = this.panel.getBibDatabaseContext().getMetaData().getEncoding();
        this.encoding.setSelectedItem(charset.orElse(Globals.prefs.getDefaultEncoding()));
        Optional<SaveOrderConfig> storedSaveOrderConfig = this.metaData.getSaveOrderConfig();
        if (!storedSaveOrderConfig.isPresent()) {
            this.saveInOriginalOrder.setSelected(true);
            this.oldSaveOrderConfig = SaveOrderConfig.getDefaultSaveOrder();
            selected = false;
        } else {
            SaveOrderConfig saveOrderConfig;
            this.oldSaveOrderConfig = saveOrderConfig = storedSaveOrderConfig.get();
            if (saveOrderConfig.saveInOriginalOrder) {
                this.saveInOriginalOrder.setSelected(true);
                selected = false;
            } else {
                this.saveInSpecifiedOrder.setSelected(true);
                selected = true;
            }
            this.saveOrderPanel.setSaveOrderConfig(saveOrderConfig);
        }
        this.saveOrderPanel.setEnabled(selected);
        Optional<String> fileD = this.metaData.getDefaultFileDirectory();
        if (fileD.isPresent()) {
            this.fileDir.setText(fileD.get().trim());
        } else {
            this.fileDir.setText("");
        }
        String fileDI = this.metaData.getUserFileDirectory(Globals.prefs.getUser()).orElse("");
        this.fileDirIndv.setText(fileDI);
        this.oldFileIndvVal = this.fileDirIndv.getText();
        this.protect.setSelected(this.metaData.isProtected());
        this.oldFileVal = this.fileDir.getText();
        this.oldProtectVal = this.protect.isSelected();
        this.fieldFormatterCleanupsPanel.setValues(this.metaData);
    }

    private void storeSettings() {
        boolean changed;
        boolean saveActionsChanged;
        boolean saveOrderConfigChanged;
        Charset oldEncoding = this.panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding());
        Charset newEncoding = (Charset)this.encoding.getSelectedItem();
        this.panel.getBibDatabaseContext().getMetaData().setEncoding(newEncoding);
        String text = this.fileDir.getText().trim();
        if (text.isEmpty()) {
            this.metaData.clearDefaultFileDirectory();
        } else {
            this.metaData.setDefaultFileDirectory(text);
        }
        text = this.fileDirIndv.getText();
        if (text.isEmpty()) {
            this.metaData.clearUserFileDirectory(Globals.prefs.getUser());
        } else {
            this.metaData.setUserFileDirectory(Globals.prefs.getUser(), text);
        }
        if (this.protect.isSelected()) {
            this.metaData.markAsProtected();
        } else {
            this.metaData.markAsNotProtected();
        }
        SaveOrderConfig newSaveOrderConfig = this.getNewSaveOrderConfig();
        boolean bl = saveOrderConfigChanged = !this.getNewSaveOrderConfig().equals(this.oldSaveOrderConfig);
        if (saveOrderConfigChanged) {
            if (newSaveOrderConfig.equals(SaveOrderConfig.getDefaultSaveOrder())) {
                this.metaData.clearSaveOrderConfig();
            } else {
                this.metaData.setSaveOrderConfig(newSaveOrderConfig);
            }
        }
        if (saveActionsChanged = this.fieldFormatterCleanupsPanel.hasChanged()) {
            if (this.fieldFormatterCleanupsPanel.isDefaultSaveActions()) {
                this.metaData.clearSaveActions();
            } else {
                this.fieldFormatterCleanupsPanel.storeSettings(this.metaData);
            }
        }
        boolean bl2 = changed = saveOrderConfigChanged || !newEncoding.equals(oldEncoding) || !this.oldFileVal.equals(this.fileDir.getText()) || !this.oldFileIndvVal.equals(this.fileDirIndv.getText()) || this.oldProtectVal != this.protect.isSelected() || saveActionsChanged;
        if (changed) {
            this.panel.markNonUndoableBaseChanged();
        }
    }
}

