/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.model.entry.BibEntry;

public class TransferableEntrySelection
implements Transferable {
    public static final DataFlavor FLAVOR_INTERNAL;
    private static final DataFlavor FLAVOR_EXTERNAL;
    private static final DataFlavor[] FLAVORS;
    private final List<BibEntry> selectedEntries;
    private final String selectedEntriesCiteKeys;
    private boolean includeCiteKeyword;

    public TransferableEntrySelection(List<BibEntry> list) {
        this.selectedEntries = list;
        this.selectedEntriesCiteKeys = String.join((CharSequence)",", this.selectedEntries.stream().map(BibEntry::getCiteKeyOptional).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor someFlavor) {
        return someFlavor.equals(FLAVOR_INTERNAL) || someFlavor.equals(FLAVOR_EXTERNAL);
    }

    @Override
    public Object getTransferData(DataFlavor someFlavor) throws UnsupportedFlavorException, IOException {
        String s2;
        String string = s2 = this.includeCiteKeyword ? "\\cite{" + this.selectedEntriesCiteKeys + "}" : this.selectedEntriesCiteKeys;
        if (someFlavor.equals(FLAVOR_INTERNAL)) {
            return this;
        }
        if (someFlavor.equals(DataFlavor.getTextPlainUnicodeFlavor())) {
            String charsetName = FLAVOR_EXTERNAL.getParameter("charset");
            if (charsetName == null) {
                charsetName = "";
            }
            Charset charset = Charset.forName(charsetName.trim());
            return new ByteArrayInputStream(s2.getBytes(charset));
        }
        return s2;
    }

    public List<BibEntry> getSelection() {
        return this.selectedEntries;
    }

    public void setIncludeCiteKeyword(boolean includeCiteKeyword) {
        this.includeCiteKeyword = includeCiteKeyword;
    }

    static {
        DataFlavor df1 = null;
        DataFlavor df2 = null;
        try {
            df1 = new DataFlavor("application/x-java-jvm-local-objectref;class=org.jabref.gui.groups.TransferableEntrySelection");
            df2 = DataFlavor.getTextPlainUnicodeFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        FLAVOR_INTERNAL = df1;
        FLAVOR_EXTERNAL = df2;
        FLAVORS = new DataFlavor[]{FLAVOR_INTERNAL, FLAVOR_EXTERNAL};
    }
}

