/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jabref.model.auxparser.AuxParser;
import org.jabref.model.auxparser.AuxParserResult;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;

public class TexGroup
extends AbstractGroup
implements FileUpdateListener {
    private static final Log LOGGER = LogFactory.getLog(TexGroup.class);
    private Path filePath;
    private Set<String> keysUsedInAux = null;
    private final FileUpdateMonitor fileMonitor;
    private AuxParser auxParser;

    public TexGroup(String name, GroupHierarchyType context, Path filePath, AuxParser auxParser, FileUpdateMonitor fileMonitor) throws IOException {
        super(name, context);
        this.filePath = Objects.requireNonNull(filePath);
        this.auxParser = auxParser;
        this.fileMonitor = fileMonitor;
        fileMonitor.addListenerForFile(filePath, this);
    }

    @Override
    public boolean contains(BibEntry entry) {
        if (this.keysUsedInAux == null) {
            AuxParserResult auxResult = this.auxParser.parse(this.filePath);
            this.keysUsedInAux = auxResult.getUniqueKeys();
        }
        return entry.getCiteKeyOptional().map(this.keysUsedInAux::contains).orElse(false);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new TexGroup(this.name, this.context, this.filePath, this.auxParser, this.fileMonitor);
        }
        catch (IOException ex) {
            LOGGER.error(ex);
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TexGroup group = (TexGroup)o;
        return Objects.equals(this.filePath, group.filePath);
    }

    @Override
    public String toString() {
        return "TexGroup{filePath=" + this.filePath + ", keysUsedInAux=" + this.keysUsedInAux + ", auxParser=" + this.auxParser + ", fileMonitor=" + this.fileMonitor + "} " + super.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filePath);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public void fileUpdated() {
        this.keysUsedInAux = null;
    }
}

