/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableBoolean;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Set;

public class RouteElementArc
extends RouteElement {
    private ArcProto arcProto;
    private double arcBaseWidth;
    private RouteElementPort headRE;
    private RouteElementPort tailRE;
    private EPoint headConnPoint;
    private EPoint tailConnPoint;
    private String arcName;
    private TextDescriptor arcNameDescriptor;
    private int arcAngle;
    private boolean arcAngleSet;
    private ArcInst inheritFrom;
    private boolean extendArcHead;
    private boolean extendArcTail;
    private ArcInst arcInst;

    private RouteElementArc(RouteElement.RouteElementAction action, Cell cell) {
        super(action, cell);
    }

    public static RouteElementArc newArc(Cell cell, ArcProto ap, double arcBaseWidth, RouteElementPort headRE, RouteElementPort tailRE, Point2D headConnPoint, Point2D tailConnPoint, String name, TextDescriptor nameTextDescriptor, ArcInst inheritFrom, boolean extendArcHead, boolean extendArcTail, PolyMerge stayInside) {
        EPoint headEP = EPoint.snap(headConnPoint);
        EPoint tailEP = EPoint.snap(tailConnPoint);
        MutableBoolean headExtend = new MutableBoolean(extendArcHead);
        MutableBoolean tailExtend = new MutableBoolean(extendArcTail);
        if (stayInside != null) {
            Set<Layer> allLayers = stayInside.getKeySet();
            for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                Layer layer = ap.getLayer(i);
                if (layer.getFunction().isDiff() && !allLayers.contains(layer)) {
                    for (Layer other : allLayers) {
                        if (!other.getFunction().isDiff()) continue;
                        layer = other;
                        break;
                    }
                }
                double layerExtend = ap.getLayerExtend(i).getLambda();
                double arcExtendOverMin = arcBaseWidth * 0.5 - ap.getBaseExtend().getLambda();
                boolean good = stayInside.arcPolyFits(layer, headEP, tailEP, 2.0 * (arcExtendOverMin + layerExtend), headExtend, tailExtend);
                while (!good && arcBaseWidth > 0.0 && !((arcExtendOverMin = (arcBaseWidth = Math.max(arcBaseWidth - 1.0, 0.0)) * 0.5 - ap.getBaseExtend().getLambda()) < 0.0)) {
                    good = stayInside.arcPolyFits(layer, headEP, tailEP, 2.0 * (arcExtendOverMin + layerExtend), headExtend, tailExtend);
                }
                if (good) continue;
                arcBaseWidth = 0.0;
                break;
            }
        }
        RouteElementArc e = new RouteElementArc(RouteElement.RouteElementAction.newArc, cell);
        e.arcProto = ap;
        e.arcBaseWidth = arcBaseWidth;
        e.headRE = headRE;
        e.tailRE = tailRE;
        e.arcName = name;
        e.arcNameDescriptor = nameTextDescriptor;
        if (headRE.getAction() != RouteElement.RouteElementAction.newNode && headRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: headRE of newArc RouteElementArc must be newNode or existingPortInst");
        }
        if (tailRE.getAction() != RouteElement.RouteElementAction.newNode && tailRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: tailRE of newArc RouteElementArc must be newNode or existingPortInst");
        }
        headRE.addConnectingNewArc(e);
        tailRE.addConnectingNewArc(e);
        e.headConnPoint = headEP;
        e.tailConnPoint = tailEP;
        assert (e.headConnPoint != null);
        assert (e.tailConnPoint != null);
        e.arcAngle = 0;
        e.arcAngleSet = false;
        e.arcInst = null;
        e.inheritFrom = inheritFrom;
        e.extendArcHead = headExtend.booleanValue();
        e.extendArcTail = tailExtend.booleanValue();
        return e;
    }

    public static RouteElementArc deleteArc(ArcInst arcInstToDelete, EditingPreferences ep) {
        RouteElementArc e = new RouteElementArc(RouteElement.RouteElementAction.deleteArc, arcInstToDelete.getParent());
        e.arcProto = arcInstToDelete.getProto();
        e.arcBaseWidth = arcInstToDelete.getLambdaBaseWidth();
        e.headRE = RouteElementPort.existingPortInst(arcInstToDelete.getHeadPortInst(), arcInstToDelete.getHeadLocation(), ep);
        e.tailRE = RouteElementPort.existingPortInst(arcInstToDelete.getTailPortInst(), arcInstToDelete.getTailLocation(), ep);
        e.arcName = arcInstToDelete.getName();
        e.arcNameDescriptor = arcInstToDelete.getTextDescriptor(ArcInst.ARC_NAME);
        e.headConnPoint = arcInstToDelete.getHeadLocation();
        e.tailConnPoint = arcInstToDelete.getTailLocation();
        e.arcAngle = 0;
        e.arcAngleSet = false;
        e.arcInst = arcInstToDelete;
        e.inheritFrom = null;
        e.extendArcTail = true;
        e.extendArcHead = true;
        return e;
    }

    public ArcProto getArcProto() {
        return this.arcProto;
    }

    public RouteElementPort getHead() {
        return this.headRE;
    }

    public RouteElementPort getTail() {
        return this.tailRE;
    }

    public Point2D getHeadConnPoint() {
        return this.headConnPoint;
    }

    public Point2D getTailConnPoint() {
        return this.tailConnPoint;
    }

    public boolean getHeadExtension() {
        return this.extendArcHead;
    }

    public boolean getTailExtension() {
        return this.extendArcTail;
    }

    public double getArcBaseWidth() {
        return this.arcBaseWidth;
    }

    public void setArcBaseWidth(double width) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcBaseWidth = width;
        }
    }

    public void setArcAngle(int angle) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcAngle = angle;
            this.arcAngleSet = true;
        }
    }

    public int getArcAngle() {
        if (this.isArcHorizontal() && this.isArcVertical()) {
            return this.arcAngle;
        }
        if (this.isArcHorizontal()) {
            return 0;
        }
        return 900;
    }

    public void setHeadExtension(boolean e) {
        this.extendArcHead = e;
    }

    public void setTailExtension(boolean e) {
        this.extendArcTail = e;
    }

    public boolean isArcVertical() {
        Point2D head2 = this.headConnPoint;
        Point2D tail = this.tailConnPoint;
        if (head2 == null) {
            head2 = this.headRE.getLocation();
        }
        if (tail == null) {
            tail = this.tailRE.getLocation();
        }
        if (head2 == null || tail == null) {
            return false;
        }
        return head2.getX() == tail.getX();
    }

    public boolean isArcHorizontal() {
        Point2D head2 = this.headConnPoint;
        Point2D tail = this.tailConnPoint;
        if (head2 == null) {
            head2 = this.headRE.getLocation();
        }
        if (tail == null) {
            tail = this.tailRE.getLocation();
        }
        if (head2 == null || tail == null) {
            return false;
        }
        return head2.getY() == tail.getY();
    }

    public boolean replaceArcEnd(RouteElementPort oldEnd, RouteElementPort newEnd) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            Poly poly = newEnd.getConnectingSite();
            if (this.headRE == oldEnd && poly != null && poly.contains(this.headConnPoint)) {
                this.headRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
            if (this.tailRE == oldEnd && poly != null && poly.contains(this.tailConnPoint)) {
                this.tailRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
        }
        return this.headRE != oldEnd && this.tailRE != oldEnd;
    }

    @Override
    public ElectricObject doAction(EditingPreferences ep) {
        EDatabase.serverDatabase().checkChanging();
        if (this.isDone()) {
            return null;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            ArcInst newAi;
            PortInst headPi = this.headRE.getPortInst();
            PortInst tailPi = this.tailRE.getPortInst();
            EPoint headPoint = this.headConnPoint;
            EPoint tailPoint = this.tailConnPoint;
            Poly headPoly = headPi.getPoly();
            boolean inHead = headPoly.isInside(headPoint);
            if (!inHead) {
                PrimitiveNode pNp;
                EDimension autoGrowth;
                NodeInst headNi = headPi.getNodeInst();
                if (!headNi.isCellInstance() && (autoGrowth = (pNp = (PrimitiveNode)headNi.getProto()).getAutoGrowth()) != null) {
                    headNi.resize(autoGrowth.getWidth(), autoGrowth.getHeight());
                    headPoly = headPi.getPoly();
                    inHead = headPoly.isInside(headPoint);
                }
                if (!inHead) {
                    FixpRectangle headBounds = headPi.getBounds();
                    double trueX = ((RectangularShape)headBounds).getCenterX();
                    if (((RectangularShape)headBounds).getWidth() == 0.0 && trueX != headPoint.getX()) {
                        trueX = DBMath.round(((RectangularShape)headBounds).getCenterX());
                    }
                    double trueY = ((RectangularShape)headBounds).getCenterX();
                    if (((RectangularShape)headBounds).getHeight() == 0.0 && trueY != headPoint.getY()) {
                        trueY = DBMath.round(((RectangularShape)headBounds).getCenterY());
                    }
                    if (trueX == headPoint.getX() && trueY == headPoint.getY()) {
                        inHead = true;
                    }
                }
            }
            if (!inHead) {
                FixpRectangle headBounds = headPi.getBounds();
                System.out.println("Arc head (" + headPoint.getX() + "," + headPoint.getY() + ") not inside " + headPi + " which is " + ((RectangularShape)headBounds).getMinX() + "<=X<=" + ((RectangularShape)headBounds).getMaxX() + " and " + ((RectangularShape)headBounds).getMinY() + "<=Y<=" + ((RectangularShape)headBounds).getMaxY());
                System.out.println("  Arc ran from " + headPi.getNodeInst() + ", port " + headPi.getPortProto().getName() + " to " + tailPi.getNodeInst() + ", port " + tailPi.getPortProto().getName());
                headPoly = headPi.getPoly();
                return null;
            }
            Poly tailPoly = tailPi.getPoly();
            boolean inTail = tailPoly.isInside(tailPoint);
            if (!inTail) {
                PrimitiveNode pNp;
                EDimension autoGrowth;
                NodeInst tailNi = tailPi.getNodeInst();
                if (!tailNi.isCellInstance() && (autoGrowth = (pNp = (PrimitiveNode)tailNi.getProto()).getAutoGrowth()) != null) {
                    tailNi.resize(autoGrowth.getWidth(), autoGrowth.getHeight());
                    tailPoly = tailPi.getPoly();
                    inTail = tailPoly.isInside(tailPoint);
                }
                if (!inTail) {
                    FixpRectangle tailBounds = tailPi.getBounds();
                    double trueX = ((RectangularShape)tailBounds).getCenterX();
                    if (((RectangularShape)tailBounds).getWidth() == 0.0 && trueX != tailPoint.getX()) {
                        trueX = DBMath.round(((RectangularShape)tailBounds).getCenterX());
                    }
                    double trueY = ((RectangularShape)tailBounds).getCenterX();
                    if (((RectangularShape)tailBounds).getHeight() == 0.0 && trueY != tailPoint.getY()) {
                        trueY = DBMath.round(((RectangularShape)tailBounds).getCenterY());
                    }
                    if (trueX == tailPoint.getX() && trueY == tailPoint.getY()) {
                        inTail = true;
                    }
                }
            }
            if (!inTail) {
                FixpRectangle tailBounds = tailPi.getBounds();
                System.out.println("Arc tail (" + tailPoint.getX() + "," + tailPoint.getY() + ") not inside " + headPi + " which is " + ((RectangularShape)tailBounds).getMinX() + "<=X<=" + ((RectangularShape)tailBounds).getMaxX() + " and " + ((RectangularShape)tailBounds).getMinY() + "<=Y<=" + ((RectangularShape)tailBounds).getMaxY());
                System.out.println("  Arc ran from " + headPi.getNodeInst() + ", port " + headPi.getPortProto().getName() + " to " + tailPi.getNodeInst() + ", port " + tailPi.getPortProto().getName());
                return null;
            }
            double thisWidth = this.arcBaseWidth;
            if (headPoint.equals(tailPoint)) {
                if (this.extendArcHead || this.extendArcTail || !this.arcProto.getFactoryDefaultInst().isHeadExtended() && !this.arcProto.getFactoryDefaultInst().isTailExtended()) {
                    if (this.arcProto.getDefaultLambdaBaseWidth(ep) < thisWidth) {
                        thisWidth = this.arcProto.getDefaultLambdaBaseWidth(ep);
                    }
                } else if (this.arcProto != Schematics.tech().bus_arc) {
                    thisWidth = 0.0;
                }
            }
            if ((newAi = ArcInst.makeInstanceBase(this.arcProto, ep, thisWidth, headPi, tailPi, headPoint, tailPoint, this.arcName)) == null) {
                return null;
            }
            if (!this.arcAngleSet && headPoint.getX() == tailPoint.getX() && headPoint.getY() == tailPoint.getY() && this.arcAngle == 0) {
                ERectangle headRect = headPi.getNodeInst().getBounds();
                ERectangle tailRect = tailPi.getNodeInst().getBounds();
                if (Math.abs(((RectangularShape)headRect).getCenterX() - ((RectangularShape)tailRect).getCenterX()) < Math.abs(((RectangularShape)headRect).getCenterY() - ((RectangularShape)tailRect).getCenterY())) {
                    this.arcAngle = 900;
                }
            }
            if (this.arcAngle != 0) {
                newAi.setAngle(this.arcAngle);
            }
            if (this.arcName != null && this.arcNameDescriptor != null) {
                newAi.setTextDescriptor(ArcInst.ARC_NAME, this.arcNameDescriptor);
            }
            this.setDone();
            this.arcInst = newAi;
            this.arcInst.copyPropertiesFrom(this.inheritFrom);
            this.arcInst.setHeadExtended(this.extendArcHead);
            this.arcInst.setTailExtended(this.extendArcTail);
            return newAi;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            if (this.arcInst.isLinked()) {
                this.arcInst.kill();
            }
            this.setDone();
        }
        return null;
    }

    @Override
    public void addHighlightArea(Highlighter highlighter) {
        if (!this.isShowHighlight()) {
            return;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            EPoint headPoint = this.headConnPoint;
            EPoint tailPoint = this.tailConnPoint;
            double offset = 0.5 * this.getArcBaseWidth();
            Cell cell = this.getCell();
            int angle = ((Point2D)headPoint).equals(tailPoint) ? 0 : GenMath.figureAngle(tailPoint, headPoint);
            double length = ((Point2D)headPoint).distance(tailPoint);
            Poly poly = Poly.makeEndPointPoly(length, this.getArcBaseWidth(), angle, headPoint, offset, tailPoint, offset, Poly.Type.FILLED);
            PolyBase.Point[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                int last2 = i - 1;
                if (last2 < 0) {
                    last2 = points.length - 1;
                }
                highlighter.addLine(points[last2], points[i], cell);
            }
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            highlighter.addElectricObject(this.arcInst, this.getCell());
        }
    }

    @Override
    public String toString() {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            return "RouteElementArc-new " + this.arcProto + " width=" + this.arcBaseWidth + ",\n   head: " + this.headRE + " at (" + this.headConnPoint.getX() + "," + this.headConnPoint.getY() + ")\n   tail: " + this.tailRE + " at (" + this.tailConnPoint.getX() + "," + this.tailConnPoint.getY() + ")";
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            return "RouteElementArc-delete " + this.arcInst;
        }
        return "RouteElement bad action";
    }
}

