/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem.nativefs.impl;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.ftpserver.filesystem.nativefs.impl.NameEqualsFileFilter;
import org.apache.ftpserver.filesystem.nativefs.impl.NativeFtpFile;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemView
implements FileSystemView {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemView.class);
    private String rootDir;
    private String currDir;
    private final User user;
    private final boolean caseInsensitive;

    protected NativeFileSystemView(User user) throws FtpException {
        this(user, false);
    }

    public NativeFileSystemView(User user, boolean caseInsensitive) throws FtpException {
        if (user == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        if (user.getHomeDirectory() == null) {
            throw new IllegalArgumentException("User home directory can not be null");
        }
        this.caseInsensitive = caseInsensitive;
        String rootDir = user.getHomeDirectory();
        rootDir = this.normalizeSeparateChar(rootDir);
        rootDir = this.appendSlash(rootDir);
        this.LOG.debug("Native filesystem view created for user \"{}\" with root \"{}\"", (Object)user.getName(), (Object)rootDir);
        this.rootDir = rootDir;
        this.user = user;
        this.currDir = "/";
    }

    public FtpFile getHomeDirectory() {
        return new NativeFtpFile("/", new File(this.rootDir), this.user);
    }

    public FtpFile getWorkingDirectory() {
        NativeFtpFile fileObj = null;
        if (this.currDir.equals("/")) {
            fileObj = new NativeFtpFile("/", new File(this.rootDir), this.user);
        } else {
            File file = new File(this.rootDir, this.currDir.substring(1));
            fileObj = new NativeFtpFile(this.currDir, file, this.user);
        }
        return fileObj;
    }

    public FtpFile getFile(String file) {
        String physicalName = this.getPhysicalName(this.rootDir, this.currDir, file, this.caseInsensitive);
        File fileObj = new File(physicalName);
        String userFileName = physicalName.substring(this.rootDir.length() - 1);
        return new NativeFtpFile(userFileName, fileObj, this.user);
    }

    public boolean changeWorkingDirectory(String dir) {
        File dirObj = new File(dir = this.getPhysicalName(this.rootDir, this.currDir, dir, this.caseInsensitive));
        if (!dirObj.isDirectory()) {
            return false;
        }
        if ((dir = dir.substring(this.rootDir.length() - 1)).charAt(dir.length() - 1) != '/') {
            dir = dir + '/';
        }
        this.currDir = dir;
        return true;
    }

    public boolean isRandomAccessible() {
        return true;
    }

    public void dispose() {
    }

    protected String getPhysicalName(String rootDir, String currDir, String fileName, boolean caseInsensitive) {
        String result;
        String normalizedRootDir = this.normalizeSeparateChar(rootDir);
        normalizedRootDir = this.appendSlash(normalizedRootDir);
        String normalizedFileName = this.normalizeSeparateChar(fileName);
        if (normalizedFileName.charAt(0) != '/') {
            String normalizedCurrDir = this.normalize(currDir, "/");
            result = normalizedRootDir + normalizedCurrDir.substring(1);
        } else {
            result = normalizedRootDir;
        }
        result = this.trimTrailingSlash(result);
        StringTokenizer st = new StringTokenizer(normalizedFileName, "/");
        while (st.hasMoreTokens()) {
            File[] matches;
            String tok = st.nextToken();
            if (tok.equals(".")) continue;
            if (tok.equals("..")) {
                int slashIndex;
                if (!result.startsWith(normalizedRootDir) || (slashIndex = result.lastIndexOf(47)) == -1) continue;
                result = result.substring(0, slashIndex);
                continue;
            }
            if (tok.equals("~")) {
                result = this.trimTrailingSlash(normalizedRootDir);
                continue;
            }
            if (caseInsensitive && (matches = new File(result).listFiles(new NameEqualsFileFilter(tok, true))) != null && matches.length > 0) {
                tok = matches[0].getName();
            }
            result = result + '/' + tok;
        }
        if (result.length() + 1 == normalizedRootDir.length()) {
            result = result + '/';
        }
        if (!result.startsWith(normalizedRootDir)) {
            result = normalizedRootDir;
        }
        return result;
    }

    private String appendSlash(String path) {
        if (path.charAt(path.length() - 1) != '/') {
            return path + '/';
        }
        return path;
    }

    private String prependSlash(String path) {
        if (path.charAt(0) != '/') {
            return '/' + path;
        }
        return path;
    }

    private String trimTrailingSlash(String path) {
        if (path.charAt(path.length() - 1) == '/') {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String normalizeSeparateChar(String pathName) {
        String normalizedPathName = pathName.replace(File.separatorChar, '/');
        normalizedPathName = normalizedPathName.replace('\\', '/');
        return normalizedPathName;
    }

    private String normalize(String path, String defaultPath) {
        if (path == null || path.trim().length() == 0) {
            path = defaultPath;
        }
        path = this.normalizeSeparateChar(path);
        path = this.prependSlash(this.appendSlash(path));
        return path;
    }
}

