/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.common.collect.Lists;
import com.google.jstestdriver.html.HtmlDocParser;
import com.google.jstestdriver.token.BufferedTokenStream;
import com.google.jstestdriver.token.ConcreteToken;
import com.google.jstestdriver.token.Node;
import com.google.jstestdriver.token.Nodes;
import com.google.jstestdriver.token.Token;
import java.util.LinkedList;
import java.util.List;

public class HtmlDocNodeFactory
implements HtmlDocParser.NodeFactory {
    private static final Token DOC_START = ConcreteToken.from("/*:DOC");
    private static final Token EQUALS = ConcreteToken.from("=");
    private static final Token END_COMMENT = ConcreteToken.from("*/");
    private final CreateNodeStrategy createStrategy;

    public HtmlDocNodeFactory(CreateNodeStrategy createStrategy) {
        this.createStrategy = createStrategy;
    }

    public void create(BufferedTokenStream stream, Nodes nodes) {
        Token token;
        Token id = null;
        LinkedList<Token> html = Lists.newLinkedList();
        if (!DOC_START.equals(stream.read())) {
            stream.reset();
            return;
        }
        id = stream.read();
        if (!EQUALS.equals(stream.read())) {
            stream.reset();
            return;
        }
        while (stream.available() && !END_COMMENT.equals(token = stream.read())) {
            html.add(token);
        }
        stream.mark();
        nodes.add(this.createStrategy.create(id, html));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CreateNodeStrategy {
        public Node create(Token var1, List<Token> var2);
    }
}

