table dless
"data for DLESS predictions"
    (
     string chrom; "Reference sequence chromosome or scaffold"
     uint   chromStart; "Start position in chromosome"
     uint   chromEnd; "End position in chromosome"
     string name; "Name of item (id)"
     float score; "Log-odds score (bits)"
     char[10] type; "Type of prediction.  enum('conserved', 'gain', 'loss')"
     string branch; "Branch on which element was gained or lost"
     float pConsSub; "P-value of conservation in subtree beneath event"
     float pConsSup; "P-value of conservation in rest of tree"
     float pConsSubCond; "Conditional P-value of conservation in subtree given total"
     float pConsSupCond; "Conditional P-value of conservation in rest of tree given total"
     char[7] condApprox; "Whether approximation was used for conditional P-values.  enum('approx', 'exact')"
     float priorMeanSub; "Mean of prior distribution, subtree"
     float priorVarSub; "Variance of prior distribution, subtree"
     uint priorMinSub; "Min of 95% c.i., subtree"
     uint priorMaxSub; "Max of 95% c.i., subtree"
     float postMeanSub; "Mean of posterior distribution, subtree"
     float postVarSub; "Variance of posterior distribution, subtree"
     float priorMeanSup; "Mean of prior distribution, rest of tree"
     float priorVarSup; "Variance of prior distribution, rest of tree"
     uint priorMinSup; "Min of 95% c.i., rest of tree"
     uint priorMaxSup; "Max of 95% c.i., rest of tree"
     float postMeanSup; "Mean of posterior distribution, rest of tree"
     float postVarSup; "Variance of posterior distribution, rest of tree"
    )