/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.ICoreAudioClient;
import org.xmind.core.audio.ICoreAudioService;
import org.xmind.core.audio.internal.AudioDeviceManager;
import org.xmind.core.audio.internal.CoreAudioSession;

public class CoreAudioService
implements ICoreAudioService {
    private static int SESSION_ID = 0;
    private Map<String, CoreAudioSession> sessions = new HashMap<String, CoreAudioSession>(33);
    private Map<String, IAudioDevice> devices = new HashMap<String, IAudioDevice>(2);

    CoreAudioService() {
    }

    public synchronized String start(ICoreAudioClient client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("client is null.");
        }
        String deviceId = client.getRequestedDeviceId();
        IAudioDevice device = this.getDevice(deviceId);
        if (device == null) {
            throw new IllegalArgumentException("device not found: " + deviceId);
        }
        if (!device.isAvailable()) {
            throw new IllegalStateException("device not available: " + deviceId);
        }
        String sessionId = this.createSessionId(deviceId);
        CoreAudioSession session = new CoreAudioSession(sessionId, this, client, device);
        session.start();
        this.addSession(session);
        return sessionId;
    }

    private String createSessionId(String deviceId) {
        int index = SESSION_ID++;
        return String.valueOf(deviceId) + "-session-" + index;
    }

    void addSession(CoreAudioSession session) {
        this.sessions.put(session.getId(), session);
    }

    void removeSession(CoreAudioSession session) {
        this.sessions.remove(session.getId());
    }

    public synchronized void jumpTo(String sessionId, double rate) {
        CoreAudioSession session = this.sessions.get(sessionId);
        if (session != null) {
            session.getChannel().jumpTo(rate);
        }
    }

    public synchronized void stop(String sessionId) throws Exception {
        CoreAudioSession session = this.sessions.get(sessionId);
        if (session != null) {
            session.stop();
        }
    }

    public boolean isSessionActive(String sessionId) {
        CoreAudioSession session = this.sessions.get(sessionId);
        if (session != null) {
            return session.isActive();
        }
        return false;
    }

    public IAudioDevice getDevice(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        IAudioDevice device = this.devices.get(deviceId);
        if (device == null) {
            device = AudioDeviceManager.getInstance().getDevice(deviceId, this);
        }
        return device;
    }

    public boolean isDeviceAvailable(String deviceId) {
        if (deviceId == null) {
            return false;
        }
        IAudioDevice device = this.getDevice(deviceId);
        if (device == null) {
            return false;
        }
        return device.isAvailable();
    }

    public void installDevice(String deviceId, IAudioDevice device) {
        if (deviceId == null) {
            throw new IllegalArgumentException("deviceId is null");
        }
        if (device == null) {
            throw new IllegalArgumentException("device is null");
        }
        this.devices.put(deviceId, device);
    }

    public void uninstallDevice(String deviceId) {
        if (deviceId == null) {
            throw new IllegalArgumentException("deviceId is null");
        }
        this.devices.remove(deviceId);
    }

    public void dispose() {
        for (IAudioDevice device : this.devices.values()) {
            device.dispose();
        }
        this.devices.clear();
    }
}

