/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections2;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class TimelineHorizontalStructure
extends AbstractBranchStructure {
    private ITransformer t = new HorizontalFlipper();
    private boolean upwards;

    public TimelineHorizontalStructure(boolean upwards) {
        this.upwards = upwards;
    }

    @Override
    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        Rectangle topicBounds = info.getCheckedClientArea();
        topicBounds = this.t.tr(topicBounds);
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        int x = ref.x - size.width / 2;
        int y = this.isUpwards(branch) ? topicBounds.y() - size.height : topicBounds.bottom();
        Rectangle r = new Rectangle(x, y, size.width, size.height);
        info.put(pmFigure, r);
    }

    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Dimension insSize;
        Rectangle r;
        int majorSpacing = this.getMajorSpacing(branch);
        int minorSpacing = this.getMinorSpacing(branch);
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        Rectangle refBounds = info.getCheckedClientArea();
        refBounds = this.t.tr(refBounds);
        int x = ref.x + majorSpacing;
        int totalHeight = this.calcTotalChildrenHeight(branch, minorSpacing, true);
        int y = this.isUpwards(branch) ? refBounds.y() - totalHeight - majorSpacing : refBounds.bottom() + majorSpacing;
        IInsertion insertion = this.getCurrentInsertion(branch);
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        int num = subBranches.size();
        int i = 0;
        while (i < num) {
            if (insertion != null && i == insertion.getIndex()) {
                r = insertion.createRectangle(x, y);
                info.add(r);
                y += r.height + minorSpacing;
            }
            IBranchPart subBranch = subBranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            Dimension size = subBranchFigure.getPreferredSize();
            Rectangle r2 = new Rectangle(x + ins.left, y + (this.isUpwards(subBranch) ? ins.bottom : ins.top), size.width, size.height);
            info.put(subBranchFigure, r2);
            y += size.height + ins.getHeight() + minorSpacing;
            ++i;
        }
        if (insertion != null && num == insertion.getIndex() && (insSize = insertion.getSize()) != null) {
            r = new Rectangle(x, y, insSize.width, insSize.height);
            info.add(r);
        }
    }

    @Override
    protected void doFillCalloutBranches(IBranchPart branch, List<IBranchPart> calloutBranches, AbstractBranchStructure.LayoutInfo info) {
        if (branch.isCentral()) {
            for (IBranchPart calloutBranch : calloutBranches) {
                calloutBranch.getFigure().setVisible(false);
            }
            IBranchConnections2 calloutConnections = branch.getCalloutConnections();
            int index = 0;
            while (index < calloutBranches.size()) {
                IDecoration decoration = calloutConnections.getDecoration(index);
                if (decoration instanceof IBranchConnectionDecoration) {
                    ((IBranchConnectionDecoration)decoration).setVisible(branch.getFigure(), false);
                }
                ++index;
            }
            return;
        }
        IBranchPart parentBranch = branch.getParentBranch();
        int orientation = this.getChildTargetOrientation(parentBranch, branch);
        boolean left = 16 == orientation;
        boolean right = 8 == orientation;
        boolean south = 1 == orientation;
        boolean north = 4 == orientation;
        for (IBranchPart calloutBranch : calloutBranches) {
            int y;
            Rectangle parentTopicArea = info.get(branch.getTopicPart().getFigure());
            Rectangle parentBranchArea = info.getCheckedClientArea();
            IReferencedFigure calloutBranchFigure = (IReferencedFigure)calloutBranch.getFigure();
            ITopicPart calloutPart = calloutBranch.getTopicPart();
            if (calloutPart == null) continue;
            IFigure calloutFigure = calloutPart.getFigure();
            Dimension calloutSize = calloutFigure.getPreferredSize();
            org.xmind.core.util.Point position = calloutBranch.getTopic().getPosition();
            if (position == null) {
                position = new org.xmind.core.util.Point();
            }
            boolean originPosition = position.x == 0 && position.y == 0;
            int offsetX = originPosition ? 0 : position.x;
            int offsetY = originPosition ? -calloutSize.height / 2 - parentTopicArea.height / 2 - 10 : position.y;
            boolean upDown = offsetY < 0;
            int dummyCalloutX = parentTopicArea.getCenter().x + offsetX - calloutSize.width / 2;
            if (left) {
                int dx = dummyCalloutX + calloutSize.width - (parentTopicArea.x + parentTopicArea.width);
                offsetX = dx > 0 ? offsetX - dx : offsetX;
            } else if (right) {
                int dx = dummyCalloutX - parentTopicArea.x;
                offsetX = dx < 0 ? offsetX - dx : offsetX;
            }
            Point reference = info.getReference();
            Point translated = reference.getTranslated(offsetX, offsetY);
            Rectangle bounds = calloutBranchFigure.getPreferredBounds(translated);
            int subRectX = left || south || north ? parentBranchArea.x : parentBranchArea.x + parentTopicArea.width;
            int subRectY = left || right || north ? parentBranchArea.y : parentBranchArea.y + parentTopicArea.height;
            int subRectWidth = left || right ? parentBranchArea.width - parentTopicArea.width : parentBranchArea.width;
            int subRectHeight = left || right ? parentBranchArea.height : parentBranchArea.height - parentTopicArea.height;
            Rectangle subRect = new Rectangle(subRectX, subRectY, subRectWidth, subRectHeight);
            boolean touchSub = subRect.touches(bounds);
            boolean touchParentTopic = bounds.touches(parentTopicArea);
            if (touchSub) {
                y = upDown ? subRect.y - bounds.height - 10 : subRect.bottom() + 10;
                bounds.setY(y);
            } else if (touchParentTopic) {
                y = upDown ? parentTopicArea.y - bounds.height - 10 : parentTopicArea.bottom() + 10;
                bounds.setY(y);
            }
            y = this.isUpwards(branch) ? Math.min(parentBranchArea.y, bounds.bottom()) - calloutBranch.getFigure().getPreferredSize().height : Math.max(parentBranchArea.bottom(), bounds.y);
            bounds.setY(y);
            info.put((IFigure)calloutBranchFigure, bounds);
        }
    }

    private int calcTotalChildrenHeight(IBranchPart branch, int minorSpacing, boolean withInsertion) {
        Dimension insSize;
        IInsertion ins;
        int totalHeight = 0;
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        Iterator<IBranchPart> it = branch.getSubBranches().iterator();
        while (it.hasNext()) {
            IBranchPart subBranch = it.next();
            totalHeight += subBranch.getFigure().getPreferredSize().height + helper.getInsets(subBranch).getHeight();
            if (!it.hasNext()) continue;
            totalHeight += minorSpacing;
        }
        if (withInsertion && (ins = this.getCurrentInsertion(branch)) != null && (insSize = ins.getSize()) != null) {
            totalHeight += minorSpacing + insSize.height;
        }
        return totalHeight;
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        if (this.isUpwards(branch)) {
            return 1;
        }
        return 4;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return 8;
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (!branch.getSubBranches().isEmpty() && "navigate_right".equals(navReqType)) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_up".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential && "navigate_left".equals(navReqType)) {
            return branch.getTopicPart();
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        int dy;
        IFigure branchFigure = branch.getFigure();
        IReferencedFigure topicFigure = (IReferencedFigure)branch.getTopicPart().getFigure();
        Point ref = topicFigure.getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Rectangle branchBounds = this.t.tr(branchFigure.getBounds());
        Rectangle topicBounds = this.t.tr(topicFigure.getBounds());
        Rectangle childBounds = this.t.tr(key.getFigure().getBounds());
        int dx = childRef.x - ref.x;
        int n = dy = this.isUpwards(branch) ? topicBounds.y() - childRef.y : childRef.y - topicBounds.bottom();
        if (dy > 0 && childBounds.x <= ref.x) {
            if (childRef.x < branchBounds.right() + 100) {
                return Math.abs(dx) + Math.abs(dy);
            }
            int d = dx * dx + dy * dy;
            return d;
        }
        return super.calcChildDistance(branch, key);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        IFigure topicFigure = topic.getFigure();
        Point ref = ((IReferencedFigure)topicFigure).getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Dimension insSize = this.calcInsSize(key.getFigure());
        int insHeight = insSize.height;
        int minorSpacing = this.getMinorSpacing(branch);
        Rectangle topicBounds = this.t.t(topicFigure.getBounds());
        int y = 0;
        if (this.isUpwards(branch)) {
            y = topicBounds.y();
            if (!branch.getSubBranches().isEmpty()) {
                IPlusMinusPart pm = branch.getPlusMinus();
                if (pm != null) {
                    y -= pm.getFigure().getSize().height;
                }
                y -= this.calcTotalChildrenHeight(branch, minorSpacing, true);
            }
        } else {
            IPlusMinusPart plusMinus;
            y = topicBounds.bottom();
            if (!branch.getSubBranches().isEmpty() && (plusMinus = branch.getPlusMinus()) != null) {
                y += plusMinus.getFigure().getSize().height;
            }
        }
        int ret = this.calcInsIndex(branch, y, childRef, insHeight, minorSpacing, withDisabled);
        return ret;
    }

    private int calcInsIndex(IBranchPart branch, int startY, Point childRef, int insHeight, int spacing, boolean withDisabled) {
        int ret = 0;
        int sum = 0;
        List<IBranchPart> subBranches = branch.getSubBranches();
        int num = subBranches.size();
        for (IBranchPart subBranch : subBranches) {
            IFigure subFigure = subBranch.getFigure();
            int h = this.getBorderedSize((IBranchPart)branch, (IBranchPart)subBranch).height;
            int hint = startY + sum + (insHeight + h + spacing) / 2;
            if (childRef.y < hint) {
                return ret;
            }
            sum += h + spacing;
            if (!withDisabled && !subFigure.isEnabled()) continue;
            ++ret;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IReferencedFigure child) {
        return child.getSize().scale(0.8);
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        int newIndex = this.calcInsIndex(branch, key, true);
        Dimension newSize = this.calcInsSize(key.getFigure());
        return new Insertion(branch, newIndex, newSize);
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return 16;
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        if (this.isUpwards(branch)) {
            return 1;
        }
        return 4;
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 4) {
            return 1;
        }
        if (direction == 1) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    @Override
    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int x = this.getMajorSpacing(branch) + key.getInvent().getSize().width / 2;
        int y = branch.getFigure().getSize().height / 2 + this.getMajorSpacing(branch) + key.getFigure().getSize().height / 2;
        return this.getFigureLocation(branch.getFigure()).getTranslated(x, this.isUpwards(branch) ? -y : y);
    }

    private boolean isUpwards(IBranchPart branch) {
        return this.upwards;
    }
}

