/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.development.testing.DevAppServerTestConfig;
import com.google.appengine.tools.info.SdkInfo;

class DevAppServerTestHelper {
    private static final String SDK_ROOT_PROP = "appengine.sdk.root";
    static DevAppServer server;
    static String originalSdkRoot;
    static boolean started;

    DevAppServerTestHelper() {
    }

    public static DevAppServer startServer(DevAppServerTestConfig testConfig) {
        if (started) {
            throw new IllegalStateException("Dev Appserver is already running.");
        }
        originalSdkRoot = System.getProperty(SDK_ROOT_PROP);
        System.setProperty(SDK_ROOT_PROP, testConfig.getSdkRoot().getAbsolutePath());
        String address = "127.0.0.1";
        SdkInfo.includeTestingJarOnSharedPath((boolean)true);
        server = new DevAppServerFactory().createDevAppServer(testConfig.getAppDir(), testConfig.getWebXml(), testConfig.getAppEngineWebXml(), address, 0, true, testConfig.installSecurityManager(), testConfig.getClasspath());
        try {
            server.start();
            System.setProperty(testConfig.getPortSystemProperty(), Integer.toString(server.getPort()));
            started = true;
            DevAppServer devAppServer = server;
            return devAppServer;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!started) {
                server = null;
                SdkInfo.includeTestingJarOnSharedPath((boolean)false);
            }
        }
    }

    public static void stopServer() {
        SdkInfo.includeTestingJarOnSharedPath((boolean)false);
        if (server != null) {
            try {
                server.shutdown();
                server = null;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        if (originalSdkRoot == null) {
            System.clearProperty(SDK_ROOT_PROP);
        } else {
            System.setProperty(SDK_ROOT_PROP, originalSdkRoot);
        }
    }

    static {
        started = false;
    }
}

