/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStore;
import org.datanucleus.store.mapped.scostore.AbstractListStoreSpecialization;
import org.datanucleus.store.scostore.ListStore;

public abstract class AbstractListStore
extends AbstractCollectionStore
implements ListStore {
    protected boolean indexedList = true;

    protected AbstractListStore(StoreManager storeMgr, ClassLoaderResolver clr, AbstractListStoreSpecialization specialization) {
        super(storeMgr, clr, specialization);
    }

    private AbstractListStoreSpecialization getSpecialization() {
        return (AbstractListStoreSpecialization)this.specialization;
    }

    public Iterator iterator(StateManager sm) {
        return this.listIterator(sm);
    }

    public ListIterator listIterator(StateManager sm) {
        return this.listIterator(sm, -1, -1);
    }

    protected abstract ListIterator listIterator(StateManager var1, int var2, int var3);

    public boolean add(StateManager sm, Object element, int size) {
        return this.internalAdd(sm, 0, true, Collections.singleton(element), size);
    }

    public void add(StateManager sm, Object element, int index, int size) {
        this.internalAdd(sm, index, false, Collections.singleton(element), size);
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        return this.internalAdd(sm, 0, true, elements, size);
    }

    public boolean addAll(StateManager sm, Collection elements, int index, int size) {
        return this.internalAdd(sm, index, false, elements, size);
    }

    protected abstract boolean internalAdd(StateManager var1, int var2, boolean var3, Collection var4, int var5);

    public Object get(StateManager sm, int index) {
        ListIterator iter = this.listIterator(sm, index, index);
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        if (!this.indexedList) {
            Object obj = null;
            int position = 0;
            while (iter.hasNext()) {
                obj = iter.next();
                if (position == index) {
                    return obj;
                }
                ++position;
            }
        }
        return iter.next();
    }

    public int indexOf(StateManager sm, Object element) {
        this.validateElementForReading(sm, element);
        return this.getSpecialization().indexOf(sm, element, this);
    }

    public int lastIndexOf(StateManager sm, Object element) {
        this.validateElementForReading(sm, element);
        return this.getSpecialization().lastIndexOf(sm, element, this);
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        if (this.indexedList) {
            int[] indices = this.getIndicesOf(sm, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.removeAt(sm, indices[i], -1);
                modified = true;
            }
        } else {
            throw new NucleusException("Not yet implemented AbstractListStore.remove for ordered lists");
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        Object elementToRemove = element;
        ObjectManager om = sm.getObjectManager();
        if (om.getApiAdapter().isDetached(element)) {
            elementToRemove = om.findObject(om.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = this.internalRemove(sm, elementToRemove, size);
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (allowDependentField && collmd.isDependentElement() && !collmd.isEmbeddedElement()) {
            sm.getObjectManager().deleteObjectInternal(elementToRemove);
        }
        return modified;
    }

    protected abstract boolean internalRemove(StateManager var1, Object var2, int var3);

    public Object remove(StateManager sm, int index, int size) {
        Object element = this.get(sm, index);
        if (this.indexedList) {
            this.removeAt(sm, index, size);
        } else {
            this.internalRemove(sm, element, size);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && !this.contains(sm, element)) {
            sm.getObjectManager().deleteObjectInternal(element);
        }
        return element;
    }

    protected abstract void removeAt(StateManager var1, int var2, int var3);

    public List subList(StateManager sm, int startIdx, int endIdx) {
        ListIterator iter = this.listIterator(sm, startIdx, endIdx);
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (!this.indexedList && list.size() > endIdx - startIdx) {
            return list.subList(startIdx, endIdx);
        }
        return list;
    }

    protected int[] getIndicesOf(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForReading(sm, iter.next());
        }
        return this.getSpecialization().getIndicesOf(sm, elements, this);
    }
}

