/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.BitSet;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSetStringConverter
implements ObjectStringConverter<BitSet> {
    @Override
    public BitSet toObject(String str) {
        if (str == null) {
            return null;
        }
        BitSet set = new BitSet();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                int position = new Integer(token);
                set.set(position);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)BitSet.class.getName()), nfe);
            }
        }
        return set;
    }

    @Override
    public String toString(BitSet set) {
        return set != null ? set.toString() : null;
    }
}

