/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarStringConverter
implements ObjectStringConverter<Calendar> {
    static SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

    @Override
    public Calendar toObject(String str) {
        if (str == null) {
            return null;
        }
        try {
            Date date = format.parse(str);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException pe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Calendar.class.getName()), pe);
        }
    }

    @Override
    public String toString(Calendar cal) {
        return cal != null ? format.format(cal.getTime()) : null;
    }
}

