/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.TemplateObjectModel;
import com.google.appengine.tools.appstats.TemplateValueHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class TemplateTool {
    private static final Logger LOG = Logger.getLogger(TemplateTool.class.getName());
    private boolean caching = true;
    private boolean strict = false;
    private Map<String, TemplateObjectModel> templateCache = new ConcurrentHashMap<String, TemplateObjectModel>();

    public TemplateTool(Option ... options) {
        for (Option option : options) {
            option.configure(this);
        }
    }

    public void format(Map<String, ?> parameters, Writer out, String templateName, String ... parents) throws IOException, ParseException {
        TemplateObjectModel parent = null;
        for (int i = parents.length - 1; i >= 0; --i) {
            parent = this.getTemplate(parents[i], parent);
        }
        TemplateObjectModel tom = this.getTemplate(templateName, parent);
        TemplateValueHelper data = new TemplateValueHelper(parameters, this.strict);
        data.setTemplateTool(this);
        tom.execute(out, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharSequence loadTemplateSource(String name) throws IOException {
        Reader resource = null;
        try {
            resource = new InputStreamReader(this.getClass().getResourceAsStream(name), "UTF-8");
            BufferedReader in = new BufferedReader(resource);
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[100];
            int i = 0;
            while (i >= 0) {
                i = in.read(buffer);
                if (i < 0) continue;
                sb.append(buffer, 0, i);
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.WARNING, "encoding UTF-8 does not seem to be supported", e);
            CharSequence charSequence = null;
            return charSequence;
        }
        finally {
            if (resource != null) {
                resource.close();
            }
        }
    }

    TemplateObjectModel getTemplate(String name, TemplateObjectModel parent) throws IOException, ParseException {
        if (this.caching && this.templateCache.containsKey(name)) {
            return this.templateCache.get(name);
        }
        CharSequence rawString = this.loadTemplateSource(name);
        if (rawString == null) {
            return null;
        }
        TemplateObjectModel model = TemplateObjectModel.buildFrom(rawString, parent, this);
        if (this.caching && model != null) {
            this.templateCache.put(name, model);
        }
        return model;
    }

    public static enum Option {
        NO_CACHE,
        STRICT,
        NON_STRICT;


        private void configure(TemplateTool tool) {
            switch (this) {
                case NO_CACHE: {
                    tool.caching = false;
                    tool.templateCache = null;
                    break;
                }
                case STRICT: {
                    tool.strict = true;
                    break;
                }
                case NON_STRICT: {
                    tool.strict = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown option: " + (Object)((Object)this));
                }
            }
        }
    }
}

