/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.el;

class PrimitiveObjects {
    static int BYTE_LOWER_BOUND = 0;
    static int BYTE_UPPER_BOUND = 255;
    static int CHARACTER_LOWER_BOUND = 0;
    static int CHARACTER_UPPER_BOUND = 255;
    static int SHORT_LOWER_BOUND = -1000;
    static int SHORT_UPPER_BOUND = 1000;
    static int INTEGER_LOWER_BOUND = -1000;
    static int INTEGER_UPPER_BOUND = 1000;
    static int LONG_LOWER_BOUND = -1000;
    static int LONG_UPPER_BOUND = 1000;
    static Byte[] mBytes = PrimitiveObjects.createBytes();
    static Character[] mCharacters = PrimitiveObjects.createCharacters();
    static Short[] mShorts = PrimitiveObjects.createShorts();
    static Integer[] mIntegers = PrimitiveObjects.createIntegers();
    static Long[] mLongs = PrimitiveObjects.createLongs();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    PrimitiveObjects() {
    }

    public static Boolean getBoolean(boolean pValue) {
        return pValue ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Byte getByte(byte pValue) {
        if (pValue >= BYTE_LOWER_BOUND && pValue <= BYTE_UPPER_BOUND) {
            return mBytes[pValue - BYTE_LOWER_BOUND];
        }
        return new Byte(pValue);
    }

    public static Character getCharacter(char pValue) {
        if (pValue >= CHARACTER_LOWER_BOUND && pValue <= CHARACTER_UPPER_BOUND) {
            return mCharacters[pValue - CHARACTER_LOWER_BOUND];
        }
        return new Character(pValue);
    }

    public static Short getShort(short pValue) {
        if (pValue >= SHORT_LOWER_BOUND && pValue <= SHORT_UPPER_BOUND) {
            return mShorts[pValue - SHORT_LOWER_BOUND];
        }
        return new Short(pValue);
    }

    public static Integer getInteger(int pValue) {
        if (pValue >= INTEGER_LOWER_BOUND && pValue <= INTEGER_UPPER_BOUND) {
            return mIntegers[pValue - INTEGER_LOWER_BOUND];
        }
        return new Integer(pValue);
    }

    public static Long getLong(long pValue) {
        if (pValue >= (long)LONG_LOWER_BOUND && pValue <= (long)LONG_UPPER_BOUND) {
            return mLongs[(int)pValue - LONG_LOWER_BOUND];
        }
        return new Long(pValue);
    }

    public static Float getFloat(float pValue) {
        return new Float(pValue);
    }

    public static Double getDouble(double pValue) {
        return new Double(pValue);
    }

    public static Class getPrimitiveObjectClass(Class pClass) {
        if (pClass == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveObjects.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (pClass == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveObjects.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (pClass == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveObjects.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (pClass == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveObjects.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (pClass == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveObjects.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (pClass == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveObjects.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (pClass == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveObjects.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (pClass == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveObjects.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return pClass;
    }

    static Byte[] createBytes() {
        int len = BYTE_UPPER_BOUND - BYTE_LOWER_BOUND + 1;
        Byte[] ret = new Byte[len];
        byte val = (byte)BYTE_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Byte(val);
            ++i;
            val = (byte)(val + 1);
        }
        return ret;
    }

    static Character[] createCharacters() {
        int len = CHARACTER_UPPER_BOUND - CHARACTER_LOWER_BOUND + 1;
        Character[] ret = new Character[len];
        char val = (char)CHARACTER_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Character(val);
            ++i;
            val = (char)(val + '\u0001');
        }
        return ret;
    }

    static Short[] createShorts() {
        int len = SHORT_UPPER_BOUND - SHORT_LOWER_BOUND + 1;
        Short[] ret = new Short[len];
        short val = (short)SHORT_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Short(val);
            ++i;
            val = (short)(val + 1);
        }
        return ret;
    }

    static Integer[] createIntegers() {
        int len = INTEGER_UPPER_BOUND - INTEGER_LOWER_BOUND + 1;
        Integer[] ret = new Integer[len];
        int val = INTEGER_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Integer(val);
            ++i;
            ++val;
        }
        return ret;
    }

    static Long[] createLongs() {
        int len = LONG_UPPER_BOUND - LONG_LOWER_BOUND + 1;
        Long[] ret = new Long[len];
        long val = LONG_LOWER_BOUND;
        int i = 0;
        while (i < len) {
            ret[i] = new Long(val);
            ++i;
            ++val;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

