/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.printers;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.cloud.sql.tool.printers.Printer;
import com.google.cloud.sql.tool.printers.PrinterUtils;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

class TabularPipedPrinter
extends Printer {
    public TabularPipedPrinter(ResultSetMetaData md, float elapsedSeconds, PrintWriter out) {
        super(md, elapsedSeconds, out);
    }

    @Override
    protected void displayHeader() throws SQLException {
        this.out.println(this.createNormalHeaderLabelLine());
    }

    @Override
    protected void displayLine(List<String> columns) {
        StringBuilder sb = new StringBuilder(256);
        for (int col = 1; col <= this.columnWidths.size(); ++col) {
            String cellText = Strings.nullToEmpty(columns.get(col - 1));
            sb.append(PrinterUtils.fixedSizeStringPadEnd(cellText, (Integer)this.columnWidths.get(col), ' ')).append(' ');
        }
        this.out.println(sb);
    }

    private String createNormalHeaderLabelLine() throws SQLException {
        int cols = this.md.getColumnCount();
        StringBuilder sb = new StringBuilder(256);
        for (int col = 1; col <= cols; ++col) {
            sb.append(PrinterUtils.getDisplayLabel(this.md, col, (Integer)this.columnWidths.get(col))).append(' ');
        }
        return sb.toString();
    }
}

