/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.sco.queued;

import org.datanucleus.StateManager;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.Store;

/**
 * Remove operation for a collection or map.
 */
public class RemoveOperation implements QueuedOperation
{
    /** The value to remove. */
    Object value;

    /** Whether to allow cascade-delete checks. */
    boolean allowCascadeDelete = true;

    /**
     * Constructor.
     * @param value The value to remove
     */
    public RemoveOperation(Object value)
    {
        this.value = value;
    }

    /**
     * Constructor, specifying whether cascade delete should be allowed.
     * @param value The value to remove
     * @param allowCascadeDelete Whether to allow cascade delete
     */
    public RemoveOperation(Object value, boolean allowCascadeDelete)
    {
        this(value);
        this.allowCascadeDelete = allowCascadeDelete;
    }

    /**
     * Perform the remove(Object) operation on the specified container.
     * @param store The backing store to perform it on
     * @param sm StateManager for the owner of the container
     */
    public void perform(Store store, StateManager sm)
    {
        if (store instanceof CollectionStore)
        {
            ((CollectionStore)store).remove(sm, value, -1, allowCascadeDelete);
        }
        else if (store instanceof MapStore)
        {
            ((MapStore)store).remove(sm, value);
        }
    }
}