/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store;

import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;

public class FederationPersistence implements StorePersistenceHandler
{
    StorePersistenceHandler store;

    public void close()
    {
        store.close();
    }

    public void deleteObject(StateManager sm)
    {
        store.deleteObject(sm);
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers)
    {
        store.fetchObject(sm, fieldNumbers);            
    }

    public Object findObject(ObjectManager om, Object id)
    {
        return store.findObject(om, id);            
    }

    public void insertObject(StateManager sm)
    {
        store.insertObject(sm);
    }

    public void locateObject(StateManager sm)
    {
        store.locateObject(sm);
    }

    public void updateObject(StateManager sm, int[] fieldNumbers)
    {
        store.updateObject(sm, fieldNumbers);
    }
}